import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import LayerManager from './layer-manager';
import ViewManager from './view-manager';
import MapView from '../views/map-view';
import EffectManager from './effect-manager';
import Effect from './effect';
import DeckRenderer from './deck-renderer';
import DeckPicker from './deck-picker';
import Tooltip from './tooltip';
import log from '../utils/log';
import { deepEqual } from '../utils/deep-equal';
import deckGlobal from './init';
import { getBrowser } from 'probe.gl/env';
import { AnimationLoop, createGLContext, instrumentGLContext, setParameters, Timeline, lumaStats } from '@luma.gl/core';
import { Stats } from 'probe.gl';
import { EventManager } from 'mjolnir.js';
import assert from '../utils/assert';
import { EVENTS } from './constants';

function noop() {}

var getCursor = function getCursor(_ref) {
  var isDragging = _ref.isDragging;
  return isDragging ? 'grabbing' : 'grab';
};

function getPropTypes(PropTypes) {
  return {
    id: PropTypes.string,
    width: PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    height: PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    layers: PropTypes.oneOfType([PropTypes.object, PropTypes.array]),
    layerFilter: PropTypes.func,
    views: PropTypes.oneOfType([PropTypes.object, PropTypes.array]),
    viewState: PropTypes.object,
    effects: PropTypes.arrayOf(PropTypes.instanceOf(Effect)),
    controller: PropTypes.oneOfType([PropTypes.func, PropTypes.bool, PropTypes.object]),
    gl: PropTypes.object,
    glOptions: PropTypes.object,
    parameters: PropTypes.object,
    pickingRadius: PropTypes.number,
    useDevicePixels: PropTypes.oneOfType([PropTypes.bool, PropTypes.number]),
    touchAction: PropTypes.string,
    onWebGLInitialized: PropTypes.func,
    onResize: PropTypes.func,
    onViewStateChange: PropTypes.func,
    onBeforeRender: PropTypes.func,
    onAfterRender: PropTypes.func,
    onLoad: PropTypes.func,
    onError: PropTypes.func,
    debug: PropTypes.bool,
    drawPickingColors: PropTypes.bool,
    _framebuffer: PropTypes.object,
    _animate: PropTypes.bool
  };
}

var defaultProps = {
  id: 'deckgl-overlay',
  width: '100%',
  height: '100%',
  pickingRadius: 0,
  layerFilter: null,
  glOptions: {},
  gl: null,
  layers: [],
  effects: [],
  views: null,
  controller: null,
  useDevicePixels: true,
  touchAction: 'none',
  _framebuffer: null,
  _animate: false,
  onWebGLInitialized: noop,
  onResize: noop,
  onViewStateChange: noop,
  onBeforeRender: noop,
  onAfterRender: noop,
  onLoad: noop,
  onError: null,
  _onMetrics: null,
  getCursor: getCursor,
  debug: false,
  drawPickingColors: false
};

var Deck = function () {
  function Deck(props) {
    _classCallCheck(this, Deck);

    props = Object.assign({}, defaultProps, props);
    this.props = {};
    this.width = 0;
    this.height = 0;
    this.viewManager = null;
    this.layerManager = null;
    this.effectManager = null;
    this.deckRenderer = null;
    this.deckPicker = null;
    this._needsRedraw = true;
    this._pickRequest = {};
    this._lastPointerDownInfo = null;
    this.viewState = null;
    this.interactiveState = {
      isDragging: false
    };
    this._onEvent = this._onEvent.bind(this);
    this._onPointerDown = this._onPointerDown.bind(this);
    this._onPointerMove = this._onPointerMove.bind(this);
    this._pickAndCallback = this._pickAndCallback.bind(this);
    this._onRendererInitialized = this._onRendererInitialized.bind(this);
    this._onRenderFrame = this._onRenderFrame.bind(this);
    this._onViewStateChange = this._onViewStateChange.bind(this);
    this._onInteractiveStateChange = this._onInteractiveStateChange.bind(this);

    if (props.viewState && props.initialViewState) {
      log.warn('View state tracking is disabled. Use either `initialViewState` for auto update or `viewState` for manual update.')();
    }

    if (getBrowser() === 'IE') {
      log.warn('IE 11 support will be deprecated in v8.0')();
    }

    if (!props.gl) {
      if (typeof document !== 'undefined') {
        this.canvas = this._createCanvas(props);
      }
    }

    this.animationLoop = this._createAnimationLoop(props);
    this.stats = new Stats({
      id: 'deck.gl'
    });
    this.metrics = {
      fps: 0,
      setPropsTime: 0,
      updateAttributesTime: 0,
      framesRedrawn: 0,
      pickTime: 0,
      pickCount: 0,
      gpuTime: 0,
      gpuTimePerFrame: 0,
      cpuTime: 0,
      cpuTimePerFrame: 0,
      bufferMemory: 0,
      textureMemory: 0,
      renderbufferMemory: 0,
      gpuMemory: 0
    };
    this._metricsCounter = 0;
    this.setProps(props);
    this.animationLoop.start();
  }

  _createClass(Deck, [{
    key: "finalize",
    value: function finalize() {
      this.animationLoop.stop();
      this.animationLoop = null;
      this._lastPointerDownInfo = null;

      if (this.layerManager) {
        this.layerManager.finalize();
        this.layerManager = null;
        this.viewManager.finalize();
        this.viewManager = null;
        this.effectManager.finalize();
        this.effectManager = null;
        this.deckRenderer.finalize();
        this.deckRenderer = null;
        this.deckPicker.finalize();
        this.deckPicker = null;
        this.eventManager.destroy();
        this.eventManager = null;
        this.tooltip.remove();
        this.tooltip = null;
      }

      if (!this.props.canvas && !this.props.gl && this.canvas) {
        this.canvas.parentElement.removeChild(this.canvas);
        this.canvas = null;
      }
    }
  }, {
    key: "setProps",
    value: function setProps(props) {
      this.stats.get('setProps Time').timeStart();

      if ('onLayerHover' in props) {
        log.removed('onLayerHover', 'onHover')();
      }

      if ('onLayerClick' in props) {
        log.removed('onLayerClick', 'onClick')();
      }

      if (props.initialViewState && !deepEqual(this.props.initialViewState, props.initialViewState)) {
        this.viewState = props.initialViewState;
      }

      Object.assign(this.props, props);

      this._setCanvasSize(this.props);

      var resolvedProps = Object.create(this.props);
      Object.assign(resolvedProps, {
        views: this._getViews(),
        width: this.width,
        height: this.height,
        viewState: this._getViewState()
      });
      this.animationLoop.setProps(resolvedProps);

      if (this.layerManager) {
        this.viewManager.setProps(resolvedProps);
        this.layerManager.activateViewport(this.getViewports()[0]);
        this.layerManager.setProps(resolvedProps);
        this.effectManager.setProps(resolvedProps);
        this.deckRenderer.setProps(resolvedProps);
        this.deckPicker.setProps(resolvedProps);
      }

      this.stats.get('setProps Time').timeEnd();
    }
  }, {
    key: "needsRedraw",
    value: function needsRedraw() {
      var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {
        clearRedrawFlags: false
      };

      if (this.props._animate) {
        return 'Deck._animate';
      }

      var redraw = this._needsRedraw;

      if (opts.clearRedrawFlags) {
        this._needsRedraw = false;
      }

      var viewManagerNeedsRedraw = this.viewManager.needsRedraw(opts);
      var layerManagerNeedsRedraw = this.layerManager.needsRedraw(opts);
      var effectManagerNeedsRedraw = this.effectManager.needsRedraw(opts);
      var deckRendererNeedsRedraw = this.deckRenderer.needsRedraw(opts);
      redraw = redraw || viewManagerNeedsRedraw || layerManagerNeedsRedraw || effectManagerNeedsRedraw || deckRendererNeedsRedraw;
      return redraw;
    }
  }, {
    key: "redraw",
    value: function redraw(force) {
      if (!this.layerManager) {
        return;
      }

      var redrawReason = force || this.needsRedraw({
        clearRedrawFlags: true
      });

      if (!redrawReason) {
        return;
      }

      this.stats.get('Redraw Count').incrementCount();

      if (this.props._customRender) {
        this.props._customRender(redrawReason);
      } else {
        this._drawLayers(redrawReason);
      }
    }
  }, {
    key: "getViews",
    value: function getViews() {
      return this.viewManager.views;
    }
  }, {
    key: "getViewports",
    value: function getViewports(rect) {
      return this.viewManager.getViewports(rect);
    }
  }, {
    key: "pickObject",
    value: function pickObject(opts) {
      var infos = this._pick('pickObject', 'pickObject Time', opts).result;

      return infos.length ? infos[0] : null;
    }
  }, {
    key: "pickMultipleObjects",
    value: function pickMultipleObjects(opts) {
      opts.depth = opts.depth || 10;
      return this._pick('pickObject', 'pickMultipleObjects Time', opts).result;
    }
  }, {
    key: "pickObjects",
    value: function pickObjects(opts) {
      return this._pick('pickObjects', 'pickObjects Time', opts);
    }
  }, {
    key: "_addResources",
    value: function _addResources(resources) {
      var forceUpdate = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

      for (var id in resources) {
        this.layerManager.resourceManager.add({
          resourceId: id,
          data: resources[id],
          forceUpdate: forceUpdate
        });
      }
    }
  }, {
    key: "_removeResources",
    value: function _removeResources(resourceIds) {
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = resourceIds[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var id = _step.value;
          this.layerManager.resourceManager.remove(id);
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator["return"] != null) {
            _iterator["return"]();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }
    }
  }, {
    key: "_pick",
    value: function _pick(method, statKey, opts) {
      var stats = this.stats;
      stats.get('Pick Count').incrementCount();
      stats.get(statKey).timeStart();
      var infos = this.deckPicker[method](Object.assign({
        layers: this.layerManager.getLayers(opts),
        viewports: this.getViewports(opts),
        onViewportActive: this.layerManager.activateViewport
      }, opts));
      stats.get(statKey).timeEnd();
      return infos;
    }
  }, {
    key: "_createCanvas",
    value: function _createCanvas(props) {
      var canvas = props.canvas;

      if (typeof canvas === 'string') {
        canvas = document.getElementById(canvas);
        assert(canvas);
      }

      if (!canvas) {
        canvas = document.createElement('canvas');
        var parent = props.parent || document.body;
        parent.appendChild(canvas);
      }

      var id = props.id,
          style = props.style;
      canvas.id = id;
      Object.assign(canvas.style, style);
      return canvas;
    }
  }, {
    key: "_setCanvasSize",
    value: function _setCanvasSize(props) {
      if (!this.canvas) {
        return;
      }

      var width = props.width,
          height = props.height;

      if (width || width === 0) {
        width = Number.isFinite(width) ? "".concat(width, "px") : width;
        this.canvas.style.width = width;
      }

      if (height || height === 0) {
        height = Number.isFinite(height) ? "".concat(height, "px") : height;
        this.canvas.style.position = 'absolute';
        this.canvas.style.height = height;
      }
    }
  }, {
    key: "_updateCanvasSize",
    value: function _updateCanvasSize() {
      if (this._checkForCanvasSizeChange()) {
        var width = this.width,
            height = this.height;
        this.viewManager.setProps({
          width: width,
          height: height
        });
        this.props.onResize({
          width: this.width,
          height: this.height
        });
      }
    }
  }, {
    key: "_checkForCanvasSizeChange",
    value: function _checkForCanvasSizeChange() {
      var canvas = this.canvas;

      if (!canvas) {
        return false;
      }

      var newWidth = canvas.clientWidth || canvas.width;
      var newHeight = canvas.clientHeight || canvas.height;

      if (newWidth !== this.width || newHeight !== this.height) {
        this.width = newWidth;
        this.height = newHeight;
        return true;
      }

      return false;
    }
  }, {
    key: "_createAnimationLoop",
    value: function _createAnimationLoop(props) {
      var _this = this;

      var width = props.width,
          height = props.height,
          gl = props.gl,
          glOptions = props.glOptions,
          debug = props.debug,
          useDevicePixels = props.useDevicePixels,
          autoResizeDrawingBuffer = props.autoResizeDrawingBuffer;
      return new AnimationLoop({
        width: width,
        height: height,
        useDevicePixels: useDevicePixels,
        autoResizeDrawingBuffer: autoResizeDrawingBuffer,
        autoResizeViewport: false,
        gl: gl,
        onCreateContext: function onCreateContext(opts) {
          return createGLContext(Object.assign({}, glOptions, opts, {
            canvas: _this.canvas,
            debug: debug
          }));
        },
        onInitialize: this._onRendererInitialized,
        onRender: this._onRenderFrame,
        onBeforeRender: props.onBeforeRender,
        onAfterRender: props.onAfterRender
      });
    }
  }, {
    key: "_getViewState",
    value: function _getViewState() {
      return this.props.viewState || this.viewState;
    }
  }, {
    key: "_getViews",
    value: function _getViews() {
      var views = this.props.views || [new MapView({
        id: 'default-view'
      })];
      views = Array.isArray(views) ? views : [views];

      if (views.length && this.props.controller) {
        views[0].props.controller = this.props.controller;
      }

      return views;
    }
  }, {
    key: "_onPointerMove",
    value: function _onPointerMove(event) {
      var _pickRequest = this._pickRequest;

      if (event.type === 'pointerleave') {
        _pickRequest.x = -1;
        _pickRequest.y = -1;
        _pickRequest.radius = 0;
      } else if (event.leftButton || event.rightButton) {
        return;
      } else {
        var pos = event.offsetCenter;

        if (!pos) {
          return;
        }

        _pickRequest.x = pos.x;
        _pickRequest.y = pos.y;
        _pickRequest.radius = this.props.pickingRadius;
      }

      if (this.layerManager) {
        this.layerManager.context.mousePosition = {
          x: _pickRequest.x,
          y: _pickRequest.y
        };
      }

      _pickRequest.event = event;
      _pickRequest.mode = 'hover';
    }
  }, {
    key: "_pickAndCallback",
    value: function _pickAndCallback() {
      var _pickRequest = this._pickRequest;

      if (_pickRequest.event) {
        var _this$_pick = this._pick('pickObject', 'pickObject Time', _pickRequest),
            result = _this$_pick.result,
            emptyInfo = _this$_pick.emptyInfo;

        var pickedInfo = emptyInfo;
        var handled = false;
        var _iteratorNormalCompletion2 = true;
        var _didIteratorError2 = false;
        var _iteratorError2 = undefined;

        try {
          for (var _iterator2 = result[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
            var info = _step2.value;
            pickedInfo = info;
            handled = info.layer.onHover(info, _pickRequest.event);
          }
        } catch (err) {
          _didIteratorError2 = true;
          _iteratorError2 = err;
        } finally {
          try {
            if (!_iteratorNormalCompletion2 && _iterator2["return"] != null) {
              _iterator2["return"]();
            }
          } finally {
            if (_didIteratorError2) {
              throw _iteratorError2;
            }
          }
        }

        if (!handled && this.props.onHover) {
          this.props.onHover(pickedInfo, _pickRequest.event);
        }

        if (this.props.getTooltip) {
          var displayInfo = this.props.getTooltip(pickedInfo);
          this.tooltip.setTooltip(displayInfo, pickedInfo.x, pickedInfo.y);
        }

        _pickRequest.event = null;
      }
    }
  }, {
    key: "_updateCursor",
    value: function _updateCursor() {
      var container = this.props.parent || this.canvas;

      if (container) {
        container.style.cursor = this.props.getCursor(this.interactiveState);
      }
    }
  }, {
    key: "_setGLContext",
    value: function _setGLContext(gl) {
      if (this.layerManager) {
        return;
      }

      if (!this.canvas) {
        this.canvas = gl.canvas;
        instrumentGLContext(gl, {
          enable: true,
          copyState: true
        });
      }

      this.tooltip = new Tooltip(this.canvas);
      setParameters(gl, {
        blend: true,
        blendFunc: [770, 771, 1, 771],
        polygonOffsetFill: true,
        depthTest: true,
        depthFunc: 515
      });
      this.props.onWebGLInitialized(gl);
      var timeline = new Timeline();
      timeline.play();
      this.animationLoop.attachTimeline(timeline);
      this.eventManager = new EventManager(this.props.parent || gl.canvas, {
        touchAction: this.props.touchAction,
        events: {
          pointerdown: this._onPointerDown,
          pointermove: this._onPointerMove,
          pointerleave: this._onPointerMove
        }
      });

      for (var eventType in EVENTS) {
        this.eventManager.on(eventType, this._onEvent);
      }

      this.viewManager = new ViewManager({
        timeline: timeline,
        eventManager: this.eventManager,
        onViewStateChange: this._onViewStateChange,
        onInteractiveStateChange: this._onInteractiveStateChange,
        views: this._getViews(),
        viewState: this._getViewState(),
        width: this.width,
        height: this.height
      });
      var viewport = this.viewManager.getViewports()[0];
      this.layerManager = new LayerManager(gl, {
        deck: this,
        stats: this.stats,
        viewport: viewport,
        timeline: timeline
      });
      this.effectManager = new EffectManager();
      this.deckRenderer = new DeckRenderer(gl);
      this.deckPicker = new DeckPicker(gl);
      this.setProps(this.props);

      this._updateCanvasSize();

      this.props.onLoad();
    }
  }, {
    key: "_drawLayers",
    value: function _drawLayers(redrawReason, renderOptions) {
      var gl = this.layerManager.context.gl;
      setParameters(gl, this.props.parameters);
      this.props.onBeforeRender({
        gl: gl
      });
      this.deckRenderer.renderLayers(Object.assign({
        target: this.props._framebuffer,
        layers: this.layerManager.getLayers(),
        viewports: this.viewManager.getViewports(),
        onViewportActive: this.layerManager.activateViewport,
        views: this.viewManager.getViews(),
        pass: 'screen',
        redrawReason: redrawReason,
        effects: this.effectManager.getEffects()
      }, renderOptions));
      this.props.onAfterRender({
        gl: gl
      });
    }
  }, {
    key: "_onRendererInitialized",
    value: function _onRendererInitialized(_ref2) {
      var gl = _ref2.gl;

      this._setGLContext(gl);
    }
  }, {
    key: "_onRenderFrame",
    value: function _onRenderFrame(animationProps) {
      this._getFrameStats();

      if (this._metricsCounter++ % 60 === 0) {
        this._getMetrics();

        this.stats.reset();
        log.table(4, this.metrics)();

        if (this.props._onMetrics) {
          this.props._onMetrics(this.metrics);
        }
      }

      this._updateCanvasSize();

      this._updateCursor();

      this.layerManager.updateLayers();

      this._pickAndCallback();

      this.redraw(false);

      if (this.viewManager) {
        this.viewManager.updateViewStates();
      }
    }
  }, {
    key: "_onViewStateChange",
    value: function _onViewStateChange(params) {
      var viewState = this.props.onViewStateChange(params) || params.viewState;

      if (this.viewState) {
        this.viewState = _objectSpread({}, this.viewState, _defineProperty({}, params.viewId, viewState));

        if (!this.props.viewState) {
          this.viewManager.setProps({
            viewState: this.viewState
          });
        }
      }
    }
  }, {
    key: "_onInteractiveStateChange",
    value: function _onInteractiveStateChange(_ref3) {
      var _ref3$isDragging = _ref3.isDragging,
          isDragging = _ref3$isDragging === void 0 ? false : _ref3$isDragging;

      if (isDragging !== this.interactiveState.isDragging) {
        this.interactiveState.isDragging = isDragging;
      }
    }
  }, {
    key: "_onEvent",
    value: function _onEvent(event) {
      var eventOptions = EVENTS[event.type];
      var pos = event.offsetCenter;

      if (!eventOptions || !pos) {
        return;
      }

      var layers = this.layerManager.getLayers();
      var info = this.deckPicker.getLastPickedObject({
        x: pos.x,
        y: pos.y,
        layers: layers,
        viewports: this.getViewports(pos)
      }, this._lastPointerDownInfo);
      var layer = info.layer;
      var layerHandler = layer && (layer[eventOptions.handler] || layer.props[eventOptions.handler]);
      var rootHandler = this.props[eventOptions.handler];
      var handled = false;

      if (layerHandler) {
        handled = layerHandler.call(layer, info, event);
      }

      if (!handled && rootHandler) {
        rootHandler(info, event);
      }
    }
  }, {
    key: "_onPointerDown",
    value: function _onPointerDown(event) {
      var pos = event.offsetCenter;
      this._lastPointerDownInfo = this.pickObject({
        x: pos.x,
        y: pos.y,
        radius: this.props.pickingRadius
      });
    }
  }, {
    key: "_getFrameStats",
    value: function _getFrameStats() {
      var stats = this.stats;
      stats.get('frameRate').timeEnd();
      stats.get('frameRate').timeStart();
      var animationLoopStats = this.animationLoop.stats;
      stats.get('GPU Time').addTime(animationLoopStats.get('GPU Time').lastTiming);
      stats.get('CPU Time').addTime(animationLoopStats.get('CPU Time').lastTiming);
    }
  }, {
    key: "_getMetrics",
    value: function _getMetrics() {
      var metrics = this.metrics,
          stats = this.stats;
      metrics.fps = stats.get('frameRate').getHz();
      metrics.setPropsTime = stats.get('setProps Time').time;
      metrics.updateAttributesTime = stats.get('Update Attributes').time;
      metrics.framesRedrawn = stats.get('Redraw Count').count;
      metrics.pickTime = stats.get('pickObject Time').time + stats.get('pickMultipleObjects Time').time + stats.get('pickObjects Time').time;
      metrics.pickCount = stats.get('Pick Count').count;
      metrics.gpuTime = stats.get('GPU Time').time;
      metrics.cpuTime = stats.get('CPU Time').time;
      metrics.gpuTimePerFrame = stats.get('GPU Time').getAverageTime();
      metrics.cpuTimePerFrame = stats.get('CPU Time').getAverageTime();
      var memoryStats = lumaStats.get('Memory Usage');
      metrics.bufferMemory = memoryStats.get('Buffer Memory').count;
      metrics.textureMemory = memoryStats.get('Texture Memory').count;
      metrics.renderbufferMemory = memoryStats.get('Renderbuffer Memory').count;
      metrics.gpuMemory = memoryStats.get('GPU Memory').count;
    }
  }]);

  return Deck;
}();

export { Deck as default };
Deck.getPropTypes = getPropTypes;
Deck.defaultProps = defaultProps;
Deck.VERSION = deckGlobal.VERSION;
//# sourceMappingURL=deck.js.map