import { registerLoaders } from '@loaders.gl/core';
import { ImageLoader } from '@loaders.gl/images';
import { global } from 'probe.gl/env';
import log from '../utils/log';
import { register } from '../debug';
import jsonLoader from '../utils/json-loader';
var version = typeof "8.2.2" !== 'undefined' ? "8.2.2" : global.DECK_VERSION || 'untranspiled source';
var existingVersion = global.deck && global.deck.VERSION;

if (existingVersion && existingVersion !== version) {
  throw new Error("deck.gl - multiple versions detected: ".concat(existingVersion, " vs ").concat(version));
}

if (!existingVersion) {
  if (process.env.NODE_ENV !== 'production') {
    log.log(0, "deck.gl ".concat(version, " - set deck.log.level=1 (or higher) to trace attribute updates"))();
  }

  global.deck = Object.assign(global.deck || {}, {
    VERSION: version,
    version: version,
    log: log,
    _registerLoggers: register
  });
  registerLoaders([jsonLoader, ImageLoader]);
}

export default global.deck;
//# sourceMappingURL=init.js.map