import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import assert from '../utils/assert';
import { deepEqual } from '../utils/deep-equal';
import log from '../utils/log';
import { flatten } from '../utils/flatten';

var ViewManager = function () {
  function ViewManager() {
    var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    _classCallCheck(this, ViewManager);

    this.views = [];
    this.width = 100;
    this.height = 100;
    this.viewState = {};
    this.controllers = {};
    this.timeline = props.timeline;
    this._viewports = [];
    this._viewportMap = {};
    this._isUpdating = false;
    this._needsRedraw = 'Initial render';
    this._needsUpdate = true;
    this._eventManager = props.eventManager;
    this._eventCallbacks = {
      onViewStateChange: props.onViewStateChange,
      onInteractiveStateChange: props.onInteractiveStateChange
    };
    Object.seal(this);
    this.setProps(props);
  }

  _createClass(ViewManager, [{
    key: "finalize",
    value: function finalize() {
      for (var key in this.controllers) {
        if (this.controllers[key]) {
          this.controllers[key].finalize();
        }
      }

      this.controllers = {};
    }
  }, {
    key: "needsRedraw",
    value: function needsRedraw() {
      var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {
        clearRedrawFlags: false
      };
      var redraw = this._needsRedraw;

      if (opts.clearRedrawFlags) {
        this._needsRedraw = false;
      }

      return redraw;
    }
  }, {
    key: "setNeedsUpdate",
    value: function setNeedsUpdate(reason) {
      this._needsUpdate = this._needsUpdate || reason;
      this._needsRedraw = this._needsRedraw || reason;
    }
  }, {
    key: "updateViewStates",
    value: function updateViewStates() {
      for (var viewId in this.controllers) {
        var controller = this.controllers[viewId];

        if (controller) {
          controller.updateTransition();
        }
      }
    }
  }, {
    key: "getViewports",
    value: function getViewports(rect) {
      if (rect) {
        return this._viewports.filter(function (viewport) {
          return viewport.containsPixel(rect);
        });
      }

      return this._viewports;
    }
  }, {
    key: "getViews",
    value: function getViews() {
      var viewMap = {};
      this.views.forEach(function (view) {
        viewMap[view.id] = view;
      });
      return viewMap;
    }
  }, {
    key: "getView",
    value: function getView(viewOrViewId) {
      return typeof viewOrViewId === 'string' ? this.views.find(function (view) {
        return view.id === viewOrViewId;
      }) : viewOrViewId;
    }
  }, {
    key: "getViewState",
    value: function getViewState(viewId) {
      var view = this.getView(viewId);
      var viewState = view && this.viewState[view.getViewStateId()] || this.viewState;
      return view ? view.filterViewState(viewState) : viewState;
    }
  }, {
    key: "getViewport",
    value: function getViewport(viewId) {
      return this._viewportMap[viewId];
    }
  }, {
    key: "unproject",
    value: function unproject(xyz, opts) {
      var viewports = this.getViewports();
      var pixel = {
        x: xyz[0],
        y: xyz[1]
      };

      for (var i = viewports.length - 1; i >= 0; --i) {
        var viewport = viewports[i];

        if (viewport.containsPixel(pixel)) {
          var p = xyz.slice();
          p[0] -= viewport.x;
          p[1] -= viewport.y;
          return viewport.unproject(p, opts);
        }
      }

      return null;
    }
  }, {
    key: "setProps",
    value: function setProps(props) {
      if ('views' in props) {
        this._setViews(props.views);
      }

      if ('viewState' in props) {
        this._setViewState(props.viewState);
      }

      if ('width' in props || 'height' in props) {
        this._setSize(props.width, props.height);
      }

      if (!this._isUpdating) {
        this._update();
      }
    }
  }, {
    key: "_update",
    value: function _update() {
      this._isUpdating = true;

      if (this._needsUpdate) {
        this._needsUpdate = false;

        this._rebuildViewports();
      }

      if (this._needsUpdate) {
        this._needsUpdate = false;

        this._rebuildViewports();
      }

      this._isUpdating = false;
    }
  }, {
    key: "_setSize",
    value: function _setSize(width, height) {
      assert(Number.isFinite(width) && Number.isFinite(height));

      if (width !== this.width || height !== this.height) {
        this.width = width;
        this.height = height;
        this.setNeedsUpdate('Size changed');
      }
    }
  }, {
    key: "_setViews",
    value: function _setViews(views) {
      views = flatten(views, Boolean);

      var viewsChanged = this._diffViews(views, this.views);

      if (viewsChanged) {
        this.setNeedsUpdate('views changed');
      }

      this.views = views;
    }
  }, {
    key: "_setViewState",
    value: function _setViewState(viewState) {
      if (viewState) {
        var viewStateChanged = !deepEqual(viewState, this.viewState);

        if (viewStateChanged) {
          this.setNeedsUpdate('viewState changed');
        }

        this.viewState = viewState;
      } else {
        log.warn('missing `viewState` or `initialViewState`')();
      }
    }
  }, {
    key: "_onViewStateChange",
    value: function _onViewStateChange(viewId, event) {
      event.viewId = viewId;

      this._eventCallbacks.onViewStateChange(event);
    }
  }, {
    key: "_createController",
    value: function _createController(view, props) {
      var Controller = props.type;
      var controller = new Controller(_objectSpread({
        timeline: this.timeline,
        eventManager: this._eventManager,
        onViewStateChange: this._onViewStateChange.bind(this, props.id),
        onStateChange: this._eventCallbacks.onInteractiveStateChange,
        makeViewport: view._getViewport.bind(view)
      }, props));
      return controller;
    }
  }, {
    key: "_updateController",
    value: function _updateController(view, viewState, viewport, controller) {
      var controllerProps = view.controller;

      if (controllerProps) {
        controllerProps = _objectSpread({}, viewState, {}, view.props, {}, controllerProps, {
          id: view.id,
          x: viewport.x,
          y: viewport.y,
          width: viewport.width,
          height: viewport.height
        });

        if (controller) {
          controller.setProps(controllerProps);
        } else {
          controller = this._createController(view, controllerProps);
        }

        return controller;
      }

      return null;
    }
  }, {
    key: "_rebuildViewports",
    value: function _rebuildViewports() {
      var width = this.width,
          height = this.height,
          views = this.views;
      var oldControllers = this.controllers;
      this._viewports = [];
      this.controllers = {};

      for (var i = views.length; i--;) {
        var view = views[i];
        var viewState = this.getViewState(view);
        var viewport = view.makeViewport({
          width: width,
          height: height,
          viewState: viewState
        });
        this.controllers[view.id] = this._updateController(view, viewState, viewport, oldControllers[view.id]);

        this._viewports.unshift(viewport);
      }

      for (var id in oldControllers) {
        if (oldControllers[id] && !this.controllers[id]) {
          oldControllers[id].finalize();
        }
      }

      this._buildViewportMap();
    }
  }, {
    key: "_buildViewportMap",
    value: function _buildViewportMap() {
      var _this = this;

      this._viewportMap = {};

      this._viewports.forEach(function (viewport) {
        if (viewport.id) {
          _this._viewportMap[viewport.id] = _this._viewportMap[viewport.id] || viewport;
        }
      });
    }
  }, {
    key: "_diffViews",
    value: function _diffViews(newViews, oldViews) {
      if (newViews.length !== oldViews.length) {
        return true;
      }

      return newViews.some(function (_, i) {
        return !newViews[i].equals(oldViews[i]);
      });
    }
  }]);

  return ViewManager;
}();

export { ViewManager as default };
//# sourceMappingURL=view-manager.js.map