import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/esm/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/esm/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/esm/inherits";
import TransitionInterpolator from './transition-interpolator';
import { lerp } from 'math.gl';
import { flyToViewport, getFlyToDuration } from '@math.gl/web-mercator';
var LINEARLY_INTERPOLATED_PROPS = ['bearing', 'pitch'];
var DEFAULT_OPTS = {
  speed: 1.2,
  curve: 1.414
};

var FlyToInterpolator = function (_TransitionInterpolat) {
  _inherits(FlyToInterpolator, _TransitionInterpolat);

  function FlyToInterpolator() {
    var _this;

    var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    _classCallCheck(this, FlyToInterpolator);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(FlyToInterpolator).call(this, {
      compare: ['longitude', 'latitude', 'zoom', 'bearing', 'pitch'],
      extract: ['width', 'height', 'longitude', 'latitude', 'zoom', 'bearing', 'pitch'],
      required: ['width', 'height', 'latitude', 'longitude', 'zoom']
    }));
    _this.props = Object.assign({}, DEFAULT_OPTS, props);
    return _this;
  }

  _createClass(FlyToInterpolator, [{
    key: "interpolateProps",
    value: function interpolateProps(startProps, endProps, t) {
      var viewport = flyToViewport(startProps, endProps, t, this.props);
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = LINEARLY_INTERPOLATED_PROPS[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var key = _step.value;
          viewport[key] = lerp(startProps[key] || 0, endProps[key] || 0, t);
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator["return"] != null) {
            _iterator["return"]();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      return viewport;
    }
  }, {
    key: "getDuration",
    value: function getDuration(startProps, endProps) {
      var transitionDuration = endProps.transitionDuration;

      if (transitionDuration === 'auto') {
        transitionDuration = getFlyToDuration(startProps, endProps, this.props);
      }

      return transitionDuration;
    }
  }]);

  return FlyToInterpolator;
}(TransitionInterpolator);

export { FlyToInterpolator as default };
//# sourceMappingURL=viewport-fly-to-interpolator.js.map