import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
import { createIterable, getAccessorFromBuffer } from './iterable-utils';
import defaultTypedArrayManager from './typed-array-manager';
import assert from './assert';
import { Buffer } from '@luma.gl/core';

var Tesselator = function () {
  function Tesselator() {
    var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    _classCallCheck(this, Tesselator);

    var _opts$attributes = opts.attributes,
        attributes = _opts$attributes === void 0 ? {} : _opts$attributes;
    this.typedArrayManager = defaultTypedArrayManager;
    this.indexStarts = null;
    this.vertexStarts = null;
    this.vertexCount = 0;
    this.instanceCount = 0;
    this.attributes = {};
    this._attributeDefs = attributes;
    this.opts = opts;
    this.updateGeometry(opts);
    Object.seal(this);
  }

  _createClass(Tesselator, [{
    key: "updateGeometry",
    value: function updateGeometry(opts) {
      Object.assign(this.opts, opts);
      var _this$opts = this.opts,
          data = _this$opts.data,
          _this$opts$buffers = _this$opts.buffers,
          buffers = _this$opts$buffers === void 0 ? {} : _this$opts$buffers,
          getGeometry = _this$opts.getGeometry,
          geometryBuffer = _this$opts.geometryBuffer,
          positionFormat = _this$opts.positionFormat,
          dataChanged = _this$opts.dataChanged,
          _this$opts$normalize = _this$opts.normalize,
          normalize = _this$opts$normalize === void 0 ? true : _this$opts$normalize;
      this.data = data;
      this.getGeometry = getGeometry;
      this.positionSize = geometryBuffer && geometryBuffer.size || (positionFormat === 'XY' ? 2 : 3);
      this.buffers = buffers;
      this.normalize = normalize;

      if (geometryBuffer) {
        assert(data.startIndices, 'binary data missing startIndices');
        this.getGeometry = this.getGeometryFromBuffer(geometryBuffer);

        if (!normalize) {
          buffers.positions = geometryBuffer;
        }
      }

      this.geometryBuffer = buffers.positions;

      if (Array.isArray(dataChanged)) {
        var _iteratorNormalCompletion = true;
        var _didIteratorError = false;
        var _iteratorError = undefined;

        try {
          for (var _iterator = dataChanged[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
            var dataRange = _step.value;

            this._rebuildGeometry(dataRange);
          }
        } catch (err) {
          _didIteratorError = true;
          _iteratorError = err;
        } finally {
          try {
            if (!_iteratorNormalCompletion && _iterator["return"] != null) {
              _iterator["return"]();
            }
          } finally {
            if (_didIteratorError) {
              throw _iteratorError;
            }
          }
        }
      } else {
        this._rebuildGeometry();
      }
    }
  }, {
    key: "updatePartialGeometry",
    value: function updatePartialGeometry(_ref) {
      var startRow = _ref.startRow,
          endRow = _ref.endRow;

      this._rebuildGeometry({
        startRow: startRow,
        endRow: endRow
      });
    }
  }, {
    key: "normalizeGeometry",
    value: function normalizeGeometry(geometry) {
      return geometry;
    }
  }, {
    key: "updateGeometryAttributes",
    value: function updateGeometryAttributes(geometry, startIndex, size) {
      throw new Error('Not implemented');
    }
  }, {
    key: "getGeometrySize",
    value: function getGeometrySize(geometry) {
      throw new Error('Not implemented');
    }
  }, {
    key: "getGeometryFromBuffer",
    value: function getGeometryFromBuffer(geometryBuffer) {
      var value = geometryBuffer.value || geometryBuffer;
      assert(ArrayBuffer.isView(value), 'cannot read geometries');
      return getAccessorFromBuffer(value, {
        size: this.positionSize,
        offset: geometryBuffer.offset,
        stride: geometryBuffer.stride,
        startIndices: this.data.startIndices
      });
    }
  }, {
    key: "_allocate",
    value: function _allocate(instanceCount, copy) {
      var attributes = this.attributes,
          buffers = this.buffers,
          _attributeDefs = this._attributeDefs,
          typedArrayManager = this.typedArrayManager;

      for (var name in _attributeDefs) {
        if (name in buffers) {
          typedArrayManager.release(attributes[name]);
          attributes[name] = null;
        } else {
          var def = _attributeDefs[name];
          def.copy = copy;
          attributes[name] = typedArrayManager.allocate(attributes[name], instanceCount, def);
        }
      }
    }
  }, {
    key: "_forEachGeometry",
    value: function _forEachGeometry(visitor, startRow, endRow) {
      var data = this.data,
          getGeometry = this.getGeometry;

      var _createIterable = createIterable(data, startRow, endRow),
          iterable = _createIterable.iterable,
          objectInfo = _createIterable.objectInfo;

      var _iteratorNormalCompletion2 = true;
      var _didIteratorError2 = false;
      var _iteratorError2 = undefined;

      try {
        for (var _iterator2 = iterable[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
          var object = _step2.value;
          objectInfo.index++;
          var geometry = getGeometry(object, objectInfo);
          visitor(geometry, objectInfo.index);
        }
      } catch (err) {
        _didIteratorError2 = true;
        _iteratorError2 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion2 && _iterator2["return"] != null) {
            _iterator2["return"]();
          }
        } finally {
          if (_didIteratorError2) {
            throw _iteratorError2;
          }
        }
      }
    }
  }, {
    key: "_rebuildGeometry",
    value: function _rebuildGeometry(dataRange) {
      var _this = this;

      if (!this.data || !this.getGeometry) {
        return;
      }

      var indexStarts = this.indexStarts,
          vertexStarts = this.vertexStarts,
          instanceCount = this.instanceCount;
      var data = this.data,
          geometryBuffer = this.geometryBuffer;

      var _ref2 = dataRange || {},
          _ref2$startRow = _ref2.startRow,
          startRow = _ref2$startRow === void 0 ? 0 : _ref2$startRow,
          _ref2$endRow = _ref2.endRow,
          endRow = _ref2$endRow === void 0 ? Infinity : _ref2$endRow;

      var normalizedData = {};

      if (!dataRange) {
        indexStarts = [0];
        vertexStarts = [0];
      }

      if (this.normalize || !geometryBuffer) {
        this._forEachGeometry(function (geometry, dataIndex) {
          geometry = _this.normalizeGeometry(geometry);
          normalizedData[dataIndex] = geometry;
          vertexStarts[dataIndex + 1] = vertexStarts[dataIndex] + _this.getGeometrySize(geometry);
        }, startRow, endRow);

        instanceCount = vertexStarts[vertexStarts.length - 1];
      } else if (geometryBuffer.buffer instanceof Buffer) {
        var byteStride = geometryBuffer.stride || this.positionSize * 4;
        vertexStarts = data.startIndices;
        instanceCount = vertexStarts[data.length] || geometryBuffer.buffer.byteLength / byteStride;
      } else {
        var bufferValue = geometryBuffer.value || geometryBuffer;
        var elementStride = geometryBuffer.stride / bufferValue.BYTES_PER_ELEMENT || this.positionSize;
        vertexStarts = data.startIndices;
        instanceCount = vertexStarts[data.length] || bufferValue.length / elementStride;
      }

      this._allocate(instanceCount, Boolean(dataRange));

      this.indexStarts = indexStarts;
      this.vertexStarts = vertexStarts;
      this.instanceCount = instanceCount;
      var context = {};

      this._forEachGeometry(function (geometry, dataIndex) {
        geometry = normalizedData[dataIndex] || geometry;
        context.vertexStart = vertexStarts[dataIndex];
        context.indexStart = indexStarts[dataIndex];
        var vertexEnd = dataIndex < vertexStarts.length - 1 ? vertexStarts[dataIndex + 1] : instanceCount;
        context.geometrySize = vertexEnd - vertexStarts[dataIndex];
        context.geometryIndex = dataIndex;

        _this.updateGeometryAttributes(geometry, context);
      }, startRow, endRow);

      this.vertexCount = indexStarts[indexStarts.length - 1];
    }
  }]);

  return Tesselator;
}();

export { Tesselator as default };
//# sourceMappingURL=tesselator.js.map