import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/esm/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/esm/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/esm/inherits";
import View from './view';
import Viewport from '../viewports/viewport';
import { getMeterZoom } from '@math.gl/web-mercator';
import { Matrix4, _SphericalCoordinates as SphericalCoordinates } from 'math.gl';
import FirstPersonController from '../controllers/first-person-controller';

function getDirectionFromBearingAndPitch(_ref) {
  var bearing = _ref.bearing,
      pitch = _ref.pitch;
  var spherical = new SphericalCoordinates({
    bearing: bearing,
    pitch: pitch
  });
  var direction = spherical.toVector3().normalize();
  return direction;
}

var FirstPersonView = function (_View) {
  _inherits(FirstPersonView, _View);

  function FirstPersonView() {
    _classCallCheck(this, FirstPersonView);

    return _possibleConstructorReturn(this, _getPrototypeOf(FirstPersonView).apply(this, arguments));
  }

  _createClass(FirstPersonView, [{
    key: "_getViewport",
    value: function _getViewport(props) {
      var _props$modelMatrix = props.modelMatrix,
          modelMatrix = _props$modelMatrix === void 0 ? null : _props$modelMatrix,
          _props$bearing = props.bearing,
          bearing = _props$bearing === void 0 ? 0 : _props$bearing,
          _props$pitch = props.pitch,
          pitch = _props$pitch === void 0 ? 0 : _props$pitch,
          _props$up = props.up,
          up = _props$up === void 0 ? [0, 0, 1] : _props$up;
      var dir = getDirectionFromBearingAndPitch({
        bearing: bearing,
        pitch: 90 + pitch
      });
      var center = modelMatrix ? modelMatrix.transformDirection(dir) : dir;
      var zoom = getMeterZoom(props);
      var scale = Math.pow(2, zoom);
      var viewMatrix = new Matrix4().lookAt({
        eye: [0, 0, 0],
        center: center,
        up: up
      }).scale(scale);
      return new Viewport(Object.assign({}, props, {
        zoom: zoom,
        viewMatrix: viewMatrix
      }));
    }
  }, {
    key: "controller",
    get: function get() {
      return this._getControllerProps({
        type: FirstPersonController
      });
    }
  }]);

  return FirstPersonView;
}(View);

export { FirstPersonView as default };
FirstPersonView.displayName = 'FirstPersonView';
//# sourceMappingURL=first-person-view.js.map