"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.register = register;
exports["default"] = debug;

var _log = _interopRequireDefault(require("../utils/log"));

var _loggers = require("./loggers");

var loggers = {};

if (process.env.NODE_ENV !== 'production') {
  loggers = (0, _loggers.getLoggers)(_log["default"]);
}

function register(handlers) {
  loggers = handlers;
}

function debug(eventType) {
  if (_log["default"].level > 0 && loggers[eventType]) {
    var _loggers$eventType;

    (_loggers$eventType = loggers[eventType]).call.apply(_loggers$eventType, arguments);
  }
}
//# sourceMappingURL=index.js.map