"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _core = require("@luma.gl/core");

var _ambientLight = require("./ambient-light");

var _directionalLight = require("./directional-light");

var _effect = _interopRequireDefault(require("../../lib/effect"));

var _math = require("math.gl");

var _shadowPass = _interopRequireDefault(require("../../passes/shadow-pass"));

var _shadow = _interopRequireDefault(require("../../shaderlib/shadow/shadow"));

var DEFAULT_AMBIENT_LIGHT_PROPS = {
  color: [255, 255, 255],
  intensity: 1.0
};
var DEFAULT_DIRECTIONAL_LIGHT_PROPS = [{
  color: [255, 255, 255],
  intensity: 1.0,
  direction: [-1, 3, -1]
}, {
  color: [255, 255, 255],
  intensity: 0.9,
  direction: [1, -8, -2.5]
}];
var DEFAULT_SHADOW_COLOR = [0, 0, 0, 200 / 255];

var LightingEffect = function (_Effect) {
  (0, _inherits2["default"])(LightingEffect, _Effect);

  function LightingEffect(props) {
    var _this;

    (0, _classCallCheck2["default"])(this, LightingEffect);
    _this = (0, _possibleConstructorReturn2["default"])(this, (0, _getPrototypeOf2["default"])(LightingEffect).call(this, props));
    _this.ambientLight = null;
    _this.directionalLights = [];
    _this.pointLights = [];
    _this.shadowColor = DEFAULT_SHADOW_COLOR;
    _this.shadowPasses = [];
    _this.shadowMaps = [];
    _this.dummyShadowMap = null;
    _this.shadow = false;
    _this.programManager = null;

    for (var key in props) {
      var lightSource = props[key];

      switch (lightSource.type) {
        case 'ambient':
          _this.ambientLight = lightSource;
          break;

        case 'directional':
          _this.directionalLights.push(lightSource);

          break;

        case 'point':
          _this.pointLights.push(lightSource);

          break;

        default:
      }
    }

    _this._applyDefaultLights();

    _this.shadow = _this.directionalLights.some(function (light) {
      return light.shadow;
    });
    return _this;
  }

  (0, _createClass2["default"])(LightingEffect, [{
    key: "preRender",
    value: function preRender(gl, _ref) {
      var layers = _ref.layers,
          layerFilter = _ref.layerFilter,
          viewports = _ref.viewports,
          onViewportActive = _ref.onViewportActive,
          views = _ref.views;
      if (!this.shadow) return;
      this.shadowMatrices = this._createLightMatrix();

      if (this.shadowPasses.length === 0) {
        this._createShadowPasses(gl);
      }

      if (!this.programManager) {
        this.programManager = _core.ProgramManager.getDefaultProgramManager(gl);

        if (_shadow["default"]) {
          this.programManager.addDefaultModule(_shadow["default"]);
        }
      }

      if (!this.dummyShadowMap) {
        this.dummyShadowMap = new _core.Texture2D(gl, {
          width: 1,
          height: 1
        });
      }

      for (var i = 0; i < this.shadowPasses.length; i++) {
        var shadowPass = this.shadowPasses[i];
        shadowPass.render({
          layers: layers,
          layerFilter: layerFilter,
          viewports: viewports,
          onViewportActive: onViewportActive,
          views: views,
          moduleParameters: {
            shadowLightId: i,
            dummyShadowMap: this.dummyShadowMap,
            shadowMatrices: this.shadowMatrices
          }
        });
      }
    }
  }, {
    key: "getModuleParameters",
    value: function getModuleParameters(layer) {
      var parameters = this.shadow ? {
        shadowMaps: this.shadowMaps,
        dummyShadowMap: this.dummyShadowMap,
        shadowColor: this.shadowColor,
        shadowMatrices: this.shadowMatrices
      } : {};
      parameters.lightSources = {
        ambientLight: this.ambientLight,
        directionalLights: this.directionalLights.map(function (directionalLight) {
          return directionalLight.getProjectedLight({
            layer: layer
          });
        }),
        pointLights: this.pointLights.map(function (pointLight) {
          return pointLight.getProjectedLight({
            layer: layer
          });
        })
      };
      return parameters;
    }
  }, {
    key: "cleanup",
    value: function cleanup() {
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = this.shadowPasses[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var shadowPass = _step.value;
          shadowPass["delete"]();
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator["return"] != null) {
            _iterator["return"]();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      this.shadowPasses.length = 0;
      this.shadowMaps.length = 0;

      if (this.dummyShadowMap) {
        this.dummyShadowMap["delete"]();
        this.dummyShadowMap = null;
      }

      if (this.shadow && this.programManager) {
        this.programManager.removeDefaultModule(_shadow["default"]);
        this.programManager = null;
      }
    }
  }, {
    key: "_createLightMatrix",
    value: function _createLightMatrix() {
      var lightMatrices = [];
      var _iteratorNormalCompletion2 = true;
      var _didIteratorError2 = false;
      var _iteratorError2 = undefined;

      try {
        for (var _iterator2 = this.directionalLights[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
          var light = _step2.value;
          var viewMatrix = new _math.Matrix4().lookAt({
            eye: new _math.Vector3(light.direction).negate()
          });
          lightMatrices.push(viewMatrix);
        }
      } catch (err) {
        _didIteratorError2 = true;
        _iteratorError2 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion2 && _iterator2["return"] != null) {
            _iterator2["return"]();
          }
        } finally {
          if (_didIteratorError2) {
            throw _iteratorError2;
          }
        }
      }

      return lightMatrices;
    }
  }, {
    key: "_createShadowPasses",
    value: function _createShadowPasses(gl) {
      for (var i = 0; i < this.directionalLights.length; i++) {
        var shadowPass = new _shadowPass["default"](gl);
        this.shadowPasses[i] = shadowPass;
        this.shadowMaps[i] = shadowPass.shadowMap;
      }
    }
  }, {
    key: "_applyDefaultLights",
    value: function _applyDefaultLights() {
      var ambientLight = this.ambientLight,
          pointLights = this.pointLights,
          directionalLights = this.directionalLights;

      if (!ambientLight && pointLights.length === 0 && directionalLights.length === 0) {
        this.ambientLight = new _ambientLight.AmbientLight(DEFAULT_AMBIENT_LIGHT_PROPS);
        this.directionalLights.push(new _directionalLight.DirectionalLight(DEFAULT_DIRECTIONAL_LIGHT_PROPS[0]), new _directionalLight.DirectionalLight(DEFAULT_DIRECTIONAL_LIGHT_PROPS[1]));
      }
    }
  }]);
  return LightingEffect;
}(_effect["default"]);

exports["default"] = LightingEffect;
//# sourceMappingURL=lighting-effect.js.map