"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _core = require("@loaders.gl/core");

var _images = require("@loaders.gl/images");

var _env = require("probe.gl/env");

var _log = _interopRequireDefault(require("../utils/log"));

var _debug = require("../debug");

var _jsonLoader = _interopRequireDefault(require("../utils/json-loader"));

var version = typeof "8.2.2" !== 'undefined' ? "8.2.2" : _env.global.DECK_VERSION || 'untranspiled source';
var existingVersion = _env.global.deck && _env.global.deck.VERSION;

if (existingVersion && existingVersion !== version) {
  throw new Error("deck.gl - multiple versions detected: ".concat(existingVersion, " vs ").concat(version));
}

if (!existingVersion) {
  if (process.env.NODE_ENV !== 'production') {
    _log["default"].log(0, "deck.gl ".concat(version, " - set deck.log.level=1 (or higher) to trace attribute updates"))();
  }

  _env.global.deck = Object.assign(_env.global.deck || {}, {
    VERSION: version,
    version: version,
    log: _log["default"],
    _registerLoggers: _debug.register
  });
  (0, _core.registerLoaders)([_jsonLoader["default"], _images.ImageLoader]);
}

var _default = _env.global.deck;
exports["default"] = _default;
//# sourceMappingURL=init.js.map