"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _attributeTransitionUtils = require("./attribute/attribute-transition-utils");

var _cpuInterpolationTransition = _interopRequireDefault(require("../transitions/cpu-interpolation-transition"));

var _cpuSpringTransition = _interopRequireDefault(require("../transitions/cpu-spring-transition"));

var _log = _interopRequireDefault(require("../utils/log"));

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var TRANSITION_TYPES = {
  interpolation: _cpuInterpolationTransition["default"],
  spring: _cpuSpringTransition["default"]
};

var UniformTransitionManager = function () {
  function UniformTransitionManager(timeline) {
    (0, _classCallCheck2["default"])(this, UniformTransitionManager);
    this.transitions = new Map();
    this.timeline = timeline;
  }

  (0, _createClass2["default"])(UniformTransitionManager, [{
    key: "add",
    value: function add(key, fromValue, toValue, settings) {
      var transitions = this.transitions;

      if (transitions.has(key)) {
        var _transition = transitions.get(key);

        fromValue = _transition.value;
        this.remove(key);
      }

      settings = (0, _attributeTransitionUtils.normalizeTransitionSettings)(settings);

      if (!settings) {
        return;
      }

      var TransitionType = TRANSITION_TYPES[settings.type];

      if (!TransitionType) {
        _log["default"].error("unsupported transition type '".concat(settings.type, "'"))();

        return;
      }

      var transition = new TransitionType(this.timeline);
      transition.start(_objectSpread({}, settings, {
        fromValue: fromValue,
        toValue: toValue
      }));
      transitions.set(key, transition);
    }
  }, {
    key: "remove",
    value: function remove(key) {
      var transitions = this.transitions;

      if (transitions.has(key)) {
        transitions.get(key).cancel();
        transitions["delete"](key);
      }
    }
  }, {
    key: "update",
    value: function update() {
      var propsInTransition = {};
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = this.transitions[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var _step$value = (0, _slicedToArray2["default"])(_step.value, 2),
              key = _step$value[0],
              transition = _step$value[1];

          transition.update();
          propsInTransition[key] = transition.value;

          if (!transition.inProgress) {
            this.remove(key);
          }
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator["return"] != null) {
            _iterator["return"]();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      return propsInTransition;
    }
  }, {
    key: "clear",
    value: function clear() {
      var _iteratorNormalCompletion2 = true;
      var _didIteratorError2 = false;
      var _iteratorError2 = undefined;

      try {
        for (var _iterator2 = this.transitions.keys()[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
          var key = _step2.value;
          this.remove(key);
        }
      } catch (err) {
        _didIteratorError2 = true;
        _iteratorError2 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion2 && _iterator2["return"] != null) {
            _iterator2["return"]();
          }
        } finally {
          if (_didIteratorError2) {
            throw _iteratorError2;
          }
        }
      }
    }
  }, {
    key: "active",
    get: function get() {
      return this.transitions.size > 0;
    }
  }]);
  return UniformTransitionManager;
}();

exports["default"] = UniformTransitionManager;
//# sourceMappingURL=uniform-transition-manager.js.map