"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _transition = _interopRequireDefault(require("./transition"));

var EPSILON = 1e-5;

function updateSpringElement(prev, cur, dest, damping, stiffness) {
  var velocity = cur - prev;
  var delta = dest - cur;
  var spring = delta * stiffness;
  var damper = -velocity * damping;
  return spring + damper + velocity + cur;
}

function updateSpring(prev, cur, dest, damping, stiffness) {
  if (Array.isArray(dest)) {
    var next = [];

    for (var i = 0; i < dest.length; i++) {
      next[i] = updateSpringElement(prev[i], cur[i], dest[i], damping, stiffness);
    }

    return next;
  }

  return updateSpringElement(prev, cur, dest, damping, stiffness);
}

function distance(value1, value2) {
  if (Array.isArray(value1)) {
    var distanceSquare = 0;

    for (var i = 0; i < value1.length; i++) {
      var d = value1[i] - value2[i];
      distanceSquare += d * d;
    }

    return Math.sqrt(distanceSquare);
  }

  return Math.abs(value1 - value2);
}

var CPUSpringTransition = function (_Transition) {
  (0, _inherits2["default"])(CPUSpringTransition, _Transition);

  function CPUSpringTransition() {
    (0, _classCallCheck2["default"])(this, CPUSpringTransition);
    return (0, _possibleConstructorReturn2["default"])(this, (0, _getPrototypeOf2["default"])(CPUSpringTransition).apply(this, arguments));
  }

  (0, _createClass2["default"])(CPUSpringTransition, [{
    key: "_onUpdate",
    value: function _onUpdate() {
      var _this$settings = this.settings,
          fromValue = _this$settings.fromValue,
          toValue = _this$settings.toValue,
          damping = _this$settings.damping,
          stiffness = _this$settings.stiffness;

      var _this$_prevValue = this._prevValue,
          _prevValue = _this$_prevValue === void 0 ? fromValue : _this$_prevValue,
          _this$_currValue = this._currValue,
          _currValue = _this$_currValue === void 0 ? fromValue : _this$_currValue;

      var nextValue = updateSpring(_prevValue, _currValue, toValue, damping, stiffness);
      var delta = distance(nextValue, toValue);
      var velocity = distance(nextValue, _currValue);

      if (delta < EPSILON && velocity < EPSILON) {
        nextValue = toValue;
        this.end();
      }

      this._prevValue = _currValue;
      this._currValue = nextValue;
    }
  }, {
    key: "value",
    get: function get() {
      return this._currValue;
    }
  }]);
  return CPUSpringTransition;
}(_transition["default"]);

exports["default"] = CPUSpringTransition;
//# sourceMappingURL=cpu-spring-transition.js.map