"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

function noop() {}

var DEFAULT_SETTINGS = {
  onStart: noop,
  onUpdate: noop,
  onInterrupt: noop,
  onEnd: noop
};

var Transition = function () {
  function Transition(timeline) {
    (0, _classCallCheck2["default"])(this, Transition);
    this._inProgress = false;
    this._handle = null;
    this.timeline = timeline;
    this.settings = {};
  }

  (0, _createClass2["default"])(Transition, [{
    key: "start",
    value: function start(props) {
      this.cancel();
      this.settings = Object.assign({}, DEFAULT_SETTINGS, props);
      this._inProgress = true;
      this.settings.onStart(this);
    }
  }, {
    key: "end",
    value: function end() {
      if (this._inProgress) {
        this.timeline.removeChannel(this._handle);
        this._handle = null;
        this._inProgress = false;
        this.settings.onEnd(this);
      }
    }
  }, {
    key: "cancel",
    value: function cancel() {
      if (this._inProgress) {
        this.settings.onInterrupt(this);
        this.timeline.removeChannel(this._handle);
        this._handle = null;
        this._inProgress = false;
      }
    }
  }, {
    key: "update",
    value: function update() {
      if (!this._inProgress) {
        return false;
      }

      if (this._handle === null) {
        var timeline = this.timeline,
            settings = this.settings;
        this._handle = timeline.addChannel({
          delay: timeline.getTime(),
          duration: settings.duration
        });
      }

      this.time = this.timeline.getTime(this._handle);

      this._onUpdate();

      this.settings.onUpdate(this);

      if (this.timeline.isFinished(this._handle)) {
        this.end();
      }

      return true;
    }
  }, {
    key: "_onUpdate",
    value: function _onUpdate() {}
  }, {
    key: "inProgress",
    get: function get() {
      return this._inProgress;
    }
  }]);
  return Transition;
}();

exports["default"] = Transition;
//# sourceMappingURL=transition.js.map