"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deepEqual = deepEqual;

function deepEqual(a, b) {
  if (a === b) {
    return true;
  }

  if (!a || !b) {
    return false;
  }

  for (var key in a) {
    var aValue = a[key];
    var bValue = b[key];
    var equals = aValue === bValue || Array.isArray(aValue) && Array.isArray(bValue) && deepEqual(aValue, bValue);

    if (!equals) {
      return false;
    }
  }

  return true;
}
//# sourceMappingURL=deep-equal.js.map