import _objectWithoutProperties from "@babel/runtime/helpers/esm/objectWithoutProperties";
import { DirectionalLight } from './directional-light';
import { getSunlightDirection } from './suncalc';
export default class SunLight extends DirectionalLight {
  constructor(_ref) {
    let {
      timestamp
    } = _ref,
        others = _objectWithoutProperties(_ref, ["timestamp"]);

    super(others);
    this.timestamp = timestamp;
  }

  getProjectedLight({
    layer
  }) {
    const {
      latitude,
      longitude
    } = layer.context.viewport;
    this.direction = getSunlightDirection(this.timestamp, latitude, longitude);
    return this;
  }

}
//# sourceMappingURL=sun-light.js.map