import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

export default class ShaderAttribute {
  constructor(dataColumn, opts) {
    this.opts = opts;
    this.source = dataColumn;
  }

  get value() {
    return this.source.value;
  }

  getValue() {
    const buffer = this.source.getBuffer();
    const accessor = this.getAccessor();

    if (buffer) {
      return [buffer, accessor];
    }

    const {
      value
    } = this.source;
    const {
      size
    } = accessor;
    let constantValue = value;

    if (value && value.length !== size) {
      constantValue = new Float32Array(size);
      const index = accessor.elementOffset || 0;

      for (let i = 0; i < size; ++i) {
        constantValue[i] = value[index + i];
      }
    }

    return constantValue;
  }

  getAccessor() {
    return _objectSpread({}, this.source.getAccessor(), {}, this.opts);
  }

}
//# sourceMappingURL=shader-attribute.js.map