import { deepEqual } from '../utils/deep-equal';
export default class LayerExtension {
  constructor(opts = {}) {
    this.opts = opts;
  }

  equals(extension) {
    if (this === extension) {
      return true;
    }

    return this.constructor === extension.constructor && deepEqual(this.opts, extension.opts);
  }

  getShaders(extension) {
    return null;
  }

  getSubLayerProps(extension) {
    const {
      defaultProps = {}
    } = extension.constructor;
    const newProps = {
      updateTriggers: {}
    };

    for (const key in defaultProps) {
      if (key in this.props) {
        const propDef = defaultProps[key];
        const propValue = this.props[key];
        newProps[key] = propValue;

        if (propDef && propDef.type === 'accessor') {
          newProps.updateTriggers[key] = this.props.updateTriggers[key];

          if (typeof propValue === 'function') {
            newProps[key] = this.getSubLayerAccessor(propValue, true);
          }
        }
      }
    }

    return newProps;
  }

  initializeState(context, extension) {}

  updateState(params, extension) {}

  draw(params, extension) {}

  finalizeState(extension) {}

}
//# sourceMappingURL=layer-extension.js.map