import { LIFECYCLE } from '../lifecycle/constants';
import { createProps } from './create-props';
import { PROP_SYMBOLS } from './constants';
const {
  ASYNC_ORIGINAL,
  ASYNC_RESOLVED,
  ASYNC_DEFAULTS
} = PROP_SYMBOLS;
import ComponentState from './component-state';
const defaultProps = {};
let counter = 0;
export default class Component {
  constructor() {
    this.props = createProps.apply(this, arguments);
    this.id = this.props.id;
    this.count = counter++;
    this.lifecycle = LIFECYCLE.NO_STATE;
    this.parent = null;
    this.context = null;
    this.state = null;
    this.internalState = null;
    Object.seal(this);
  }

  clone(newProps) {
    const {
      props
    } = this;
    const asyncProps = {};

    for (const key in props[ASYNC_DEFAULTS]) {
      if (key in props[ASYNC_RESOLVED]) {
        asyncProps[key] = props[ASYNC_RESOLVED][key];
      } else if (key in props[ASYNC_ORIGINAL]) {
        asyncProps[key] = props[ASYNC_ORIGINAL][key];
      }
    }

    return new this.constructor(Object.assign({}, props, asyncProps, newProps));
  }

  get stats() {
    return this.internalState.stats;
  }

  _initState() {
    this.internalState = new ComponentState({});
  }

}
Component.componentName = 'Component';
Component.defaultProps = defaultProps;
//# sourceMappingURL=component.js.map