import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import { default as LayersPass } from './layers-pass';
import { Framebuffer, Texture2D, Renderbuffer, withParameters, cssToDeviceRatio } from '@luma.gl/core';
export default class ShadowPass extends LayersPass {
  constructor(gl, props) {
    super(gl, props);
    this.shadowMap = new Texture2D(gl, {
      width: 1,
      height: 1,
      parameters: {
        [10241]: 9729,
        [10240]: 9729,
        [10242]: 33071,
        [10243]: 33071
      }
    });
    this.depthBuffer = new Renderbuffer(gl, {
      format: 33189,
      width: 1,
      height: 1
    });
    this.fbo = new Framebuffer(gl, {
      id: 'shadowmap',
      width: 1,
      height: 1,
      attachments: {
        [36064]: this.shadowMap,
        [36096]: this.depthBuffer
      }
    });
  }

  render(params) {
    const target = this.fbo;
    withParameters(this.gl, {
      depthRange: [0, 1],
      depthTest: true,
      blend: false,
      clearColor: [1, 1, 1, 1]
    }, () => {
      const viewport = params.viewports[0];
      const pixelRatio = cssToDeviceRatio(this.gl);
      const width = viewport.width * pixelRatio;
      const height = viewport.height * pixelRatio;

      if (width !== target.width || height !== target.height) {
        target.resize({
          width,
          height
        });
      }

      super.render(_objectSpread({}, params, {
        target,
        pass: 'shadow'
      }));
    });
  }

  shouldDrawLayer(layer) {
    return layer.props.shadowEnabled !== false;
  }

  getModuleParameters() {
    return {
      drawToShadowMap: true
    };
  }

  delete() {
    if (this.fbo) {
      this.fbo.delete();
      this.fbo = null;
    }

    if (this.shadowMap) {
      this.shadowMap.delete();
      this.shadowMap = null;
    }

    if (this.depthBuffer) {
      this.depthBuffer.delete();
      this.depthBuffer = null;
    }
  }

}
//# sourceMappingURL=shadow-pass.js.map