import TransitionInterpolator from './transition-interpolator';
import { lerp } from 'math.gl';
const DEFAULT_PROPS = ['longitude', 'latitude', 'zoom', 'bearing', 'pitch'];
const DEFAULT_REQUIRED_PROPS = ['longitude', 'latitude', 'zoom'];
export default class LinearInterpolator extends TransitionInterpolator {
  constructor(transitionProps) {
    super(transitionProps || {
      compare: DEFAULT_PROPS,
      extract: DEFAULT_PROPS,
      required: DEFAULT_REQUIRED_PROPS
    });
  }

  interpolateProps(startProps, endProps, t) {
    const viewport = {};

    for (const key in endProps) {
      viewport[key] = lerp(startProps[key] || 0, endProps[key] || 0, t);
    }

    return viewport;
  }

}
//# sourceMappingURL=linear-interpolator.js.map