import TransitionInterpolator from './transition-interpolator';
import { lerp } from 'math.gl';
import { flyToViewport, getFlyToDuration } from '@math.gl/web-mercator';
const LINEARLY_INTERPOLATED_PROPS = ['bearing', 'pitch'];
const DEFAULT_OPTS = {
  speed: 1.2,
  curve: 1.414
};
export default class FlyToInterpolator extends TransitionInterpolator {
  constructor(props = {}) {
    super({
      compare: ['longitude', 'latitude', 'zoom', 'bearing', 'pitch'],
      extract: ['width', 'height', 'longitude', 'latitude', 'zoom', 'bearing', 'pitch'],
      required: ['width', 'height', 'latitude', 'longitude', 'zoom']
    });
    this.props = Object.assign({}, DEFAULT_OPTS, props);
  }

  interpolateProps(startProps, endProps, t) {
    const viewport = flyToViewport(startProps, endProps, t, this.props);

    for (const key of LINEARLY_INTERPOLATED_PROPS) {
      viewport[key] = lerp(startProps[key] || 0, endProps[key] || 0, t);
    }

    return viewport;
  }

  getDuration(startProps, endProps) {
    let {
      transitionDuration
    } = endProps;

    if (transitionDuration === 'auto') {
      transitionDuration = getFlyToDuration(startProps, endProps, this.props);
    }

    return transitionDuration;
  }

}
//# sourceMappingURL=viewport-fly-to-interpolator.js.map