function padArrayChunk({
  source,
  target,
  start = 0,
  end,
  getData
}) {
  end = end || target.length;
  const sourceLength = source.length;
  const targetLength = end - start;

  if (sourceLength > targetLength) {
    target.set(source.subarray(0, targetLength), start);
    return;
  }

  target.set(source, start);

  if (!getData) {
    return;
  }

  let i = sourceLength;

  while (i < targetLength) {
    const datum = getData(i, source);

    for (let j = 0; j < datum.length; j++) {
      target[start + i] = datum[j];
      i++;
    }
  }
}

export function padArray({
  source,
  target,
  size,
  getData,
  sourceStartIndices,
  targetStartIndices
}) {
  if (!Array.isArray(targetStartIndices)) {
    padArrayChunk({
      source,
      target,
      getData
    });
    return target;
  }

  let sourceIndex = 0;
  let targetIndex = 0;

  const getChunkData = getData && ((i, chunk) => getData(i + targetIndex, chunk));

  const n = Math.min(sourceStartIndices.length, targetStartIndices.length);

  for (let i = 1; i < n; i++) {
    const nextSourceIndex = sourceStartIndices[i] * size;
    const nextTargetIndex = targetStartIndices[i] * size;
    padArrayChunk({
      source: source.subarray(sourceIndex, nextSourceIndex),
      target,
      start: targetIndex,
      end: nextTargetIndex,
      getData: getChunkData
    });
    sourceIndex = nextSourceIndex;
    targetIndex = nextTargetIndex;
  }

  if (targetIndex < target.length) {
    padArrayChunk({
      source: [],
      target,
      start: targetIndex,
      getData: getChunkData
    });
  }

  return target;
}
//# sourceMappingURL=array-utils.js.map