import _get from "@babel/runtime/helpers/esm/get";
import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/esm/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/esm/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/esm/inherits";
import { clamp } from 'math.gl';
import Controller from './controller';
import { MapState } from './map-controller';
import { mod } from '../utils/math-utils';
import LinearInterpolator from '../transitions/linear-interpolator';
import { TRANSITION_EVENTS } from './transition-manager';
var LINEAR_TRANSITION_PROPS = {
  transitionDuration: 300,
  transitionEasing: function transitionEasing(t) {
    return t;
  },
  transitionInterpolator: new LinearInterpolator(['longitude', 'latitude', 'zoom']),
  transitionInterruption: TRANSITION_EVENTS.BREAK
};

var GlobeState = function (_MapState) {
  _inherits(GlobeState, _MapState);

  function GlobeState() {
    _classCallCheck(this, GlobeState);

    return _possibleConstructorReturn(this, _getPrototypeOf(GlobeState).apply(this, arguments));
  }

  _createClass(GlobeState, [{
    key: "_applyConstraints",
    value: function _applyConstraints(props) {
      var maxZoom = props.maxZoom,
          minZoom = props.minZoom,
          zoom = props.zoom;
      props.zoom = clamp(zoom, minZoom, maxZoom);
      var longitude = props.longitude,
          latitude = props.latitude;

      if (longitude < -180 || longitude > 180) {
        props.longitude = mod(longitude + 180, 360) - 180;
      }

      props.latitude = clamp(latitude, -89, 89);
      return props;
    }
  }]);

  return GlobeState;
}(MapState);

var GlobeController = function (_Controller) {
  _inherits(GlobeController, _Controller);

  function GlobeController(props) {
    var _this;

    _classCallCheck(this, GlobeController);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(GlobeController).call(this, GlobeState, props));
    _this.invertPan = true;
    return _this;
  }

  _createClass(GlobeController, [{
    key: "setProps",
    value: function setProps(props) {
      _get(_getPrototypeOf(GlobeController.prototype), "setProps", this).call(this, props);

      this.dragRotate = false;
      this.touchRotate = false;
    }
  }, {
    key: "_getTransitionProps",
    value: function _getTransitionProps() {
      return LINEAR_TRANSITION_PROPS;
    }
  }]);

  return GlobeController;
}(Controller);

export { GlobeController as default };
//# sourceMappingURL=globe-controller.js.map