import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
import { projectPosition } from '../../shaderlib/project/project-functions';
import { COORDINATE_SYSTEM } from '../../lib';
var DEFAULT_LIGHT_COLOR = [255, 255, 255];
var DEFAULT_LIGHT_INTENSITY = 1.0;
var DEFAULT_ATTENUATION = [0, 0, 1];
var DEFAULT_LIGHT_POSITION = [0.0, 0.0, 1.0];
var idCount = 0;
export var PointLight = function () {
  function PointLight() {
    var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    _classCallCheck(this, PointLight);

    var _props$color = props.color,
        color = _props$color === void 0 ? DEFAULT_LIGHT_COLOR : _props$color;
    var _props$intensity = props.intensity,
        intensity = _props$intensity === void 0 ? DEFAULT_LIGHT_INTENSITY : _props$intensity;
    var _props$position = props.position,
        position = _props$position === void 0 ? DEFAULT_LIGHT_POSITION : _props$position;
    this.id = props.id || "point-".concat(idCount++);
    this.color = color;
    this.intensity = intensity;
    this.type = 'point';
    this.position = position;
    this.attenuation = getAttenuation(props);
    this.projectedLight = Object.assign({}, this);
  }

  _createClass(PointLight, [{
    key: "getProjectedLight",
    value: function getProjectedLight(_ref) {
      var layer = _ref.layer;
      var projectedLight = this.projectedLight;
      var viewport = layer.context.viewport;
      var _layer$props = layer.props,
          coordinateSystem = _layer$props.coordinateSystem,
          coordinateOrigin = _layer$props.coordinateOrigin;
      var position = projectPosition(this.position, {
        viewport: viewport,
        coordinateSystem: coordinateSystem,
        coordinateOrigin: coordinateOrigin,
        fromCoordinateSystem: viewport.isGeospatial ? COORDINATE_SYSTEM.LNGLAT : COORDINATE_SYSTEM.CARTESIAN,
        fromCoordinateOrigin: [0, 0, 0]
      });
      projectedLight.color = this.color;
      projectedLight.intensity = this.intensity;
      projectedLight.position = position;
      return projectedLight;
    }
  }]);

  return PointLight;
}();

function getAttenuation(props) {
  if ('attenuation' in props) {
    return props.attenuation;
  }

  if ('intensity' in props) {
    return [0, 0, props.intensity];
  }

  return DEFAULT_ATTENUATION;
}
//# sourceMappingURL=point-light.js.map