import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
import Attribute from './attribute';
import log from '../../utils/log';
import debug from '../../debug';
import AttributeTransitionManager from './attribute-transition-manager';
var TRACE_INVALIDATE = 'attributeManager.invalidate';
var TRACE_UPDATE_START = 'attributeManager.updateStart';
var TRACE_UPDATE_END = 'attributeManager.updateEnd';
var TRACE_ATTRIBUTE_UPDATE_START = 'attribute.updateStart';
var TRACE_ATTRIBUTE_ALLOCATE = 'attribute.allocate';
var TRACE_ATTRIBUTE_UPDATE_END = 'attribute.updateEnd';

var AttributeManager = function () {
  function AttributeManager(gl) {
    var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
        _ref$id = _ref.id,
        id = _ref$id === void 0 ? 'attribute-manager' : _ref$id,
        stats = _ref.stats,
        timeline = _ref.timeline;

    _classCallCheck(this, AttributeManager);

    this.id = id;
    this.gl = gl;
    this.attributes = {};
    this.updateTriggers = {};
    this.accessors = {};
    this.needsRedraw = true;
    this.userData = {};
    this.stats = stats;
    this.attributeTransitionManager = new AttributeTransitionManager(gl, {
      id: "".concat(id, "-transitions"),
      timeline: timeline
    });
    Object.seal(this);
  }

  _createClass(AttributeManager, [{
    key: "finalize",
    value: function finalize() {
      for (var attributeName in this.attributes) {
        this.attributes[attributeName]["delete"]();
      }

      this.attributeTransitionManager.finalize();
    }
  }, {
    key: "getNeedsRedraw",
    value: function getNeedsRedraw() {
      var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {
        clearRedrawFlags: false
      };
      var redraw = this.needsRedraw;
      this.needsRedraw = this.needsRedraw && !opts.clearRedrawFlags;
      return redraw && this.id;
    }
  }, {
    key: "setNeedsRedraw",
    value: function setNeedsRedraw() {
      var redraw = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
      this.needsRedraw = true;
      return this;
    }
  }, {
    key: "add",
    value: function add(attributes, updaters) {
      this._add(attributes, updaters);
    }
  }, {
    key: "addInstanced",
    value: function addInstanced(attributes, updaters) {
      this._add(attributes, updaters, {
        instanced: 1
      });
    }
  }, {
    key: "remove",
    value: function remove(attributeNameArray) {
      for (var i = 0; i < attributeNameArray.length; i++) {
        var name = attributeNameArray[i];

        if (this.attributes[name] !== undefined) {
          this.attributes[name]["delete"]();
          delete this.attributes[name];
        }
      }
    }
  }, {
    key: "invalidate",
    value: function invalidate(triggerName, dataRange) {
      var invalidatedAttributes = this._invalidateTrigger(triggerName, dataRange);

      debug(TRACE_INVALIDATE, this, triggerName, invalidatedAttributes);
    }
  }, {
    key: "invalidateAll",
    value: function invalidateAll(dataRange) {
      for (var attributeName in this.attributes) {
        this.attributes[attributeName].setNeedsUpdate(attributeName, dataRange);
      }

      debug(TRACE_INVALIDATE, this, 'all');
    }
  }, {
    key: "update",
    value: function update() {
      var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          data = _ref2.data,
          numInstances = _ref2.numInstances,
          _ref2$startIndices = _ref2.startIndices,
          startIndices = _ref2$startIndices === void 0 ? null : _ref2$startIndices,
          transitions = _ref2.transitions,
          _ref2$props = _ref2.props,
          props = _ref2$props === void 0 ? {} : _ref2$props,
          _ref2$buffers = _ref2.buffers,
          buffers = _ref2$buffers === void 0 ? {} : _ref2$buffers,
          _ref2$context = _ref2.context,
          context = _ref2$context === void 0 ? {} : _ref2$context;

      var updated = false;
      debug(TRACE_UPDATE_START, this);

      if (this.stats) {
        this.stats.get('Update Attributes').timeStart();
      }

      for (var attributeName in this.attributes) {
        var attribute = this.attributes[attributeName];
        var accessorName = attribute.settings.accessor;
        attribute.startIndices = startIndices;

        if (props[attributeName]) {
          log.removed("props.".concat(attributeName), "data.attributes.".concat(attributeName))();
        }

        if (attribute.setExternalBuffer(buffers[attributeName])) {} else if (attribute.setBinaryValue(buffers[accessorName], data.startIndices)) {} else if (!buffers[accessorName] && attribute.setConstantValue(props[accessorName])) {} else if (attribute.needsUpdate()) {
          updated = true;

          this._updateAttribute({
            attribute: attribute,
            numInstances: numInstances,
            data: data,
            props: props,
            context: context
          });
        }

        this.needsRedraw |= attribute.needsRedraw();
      }

      if (updated) {
        debug(TRACE_UPDATE_END, this, numInstances);
      }

      if (this.stats) {
        this.stats.get('Update Attributes').timeEnd();
      }

      this.attributeTransitionManager.update({
        attributes: this.attributes,
        numInstances: numInstances,
        transitions: transitions
      });
    }
  }, {
    key: "updateTransition",
    value: function updateTransition() {
      var attributeTransitionManager = this.attributeTransitionManager;
      var transitionUpdated = attributeTransitionManager.run();
      this.needsRedraw = this.needsRedraw || transitionUpdated;
      return transitionUpdated;
    }
  }, {
    key: "getAttributes",
    value: function getAttributes() {
      return this.attributes;
    }
  }, {
    key: "getChangedAttributes",
    value: function getChangedAttributes() {
      var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {
        clearChangedFlags: false
      };
      var attributes = this.attributes,
          attributeTransitionManager = this.attributeTransitionManager;
      var changedAttributes = Object.assign({}, attributeTransitionManager.getAttributes());

      for (var attributeName in attributes) {
        var attribute = attributes[attributeName];

        if (attribute.needsRedraw(opts) && !attributeTransitionManager.hasAttribute(attributeName)) {
          changedAttributes[attributeName] = attribute;
        }
      }

      return changedAttributes;
    }
  }, {
    key: "getShaderAttributes",
    value: function getShaderAttributes(attributes) {
      var excludeAttributes = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      if (!attributes) {
        attributes = this.getAttributes();
      }

      var shaderAttributes = {};

      for (var attributeName in attributes) {
        if (!excludeAttributes[attributeName]) {
          Object.assign(shaderAttributes, attributes[attributeName].getShaderAttributes());
        }
      }

      return shaderAttributes;
    }
  }, {
    key: "getAccessors",
    value: function getAccessors() {
      return this.updateTriggers;
    }
  }, {
    key: "_add",
    value: function _add(attributes, updaters) {
      var extraProps = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

      if (updaters) {
        log.warn('AttributeManager.add({updaters}) - updater map no longer supported')();
      }

      var newAttributes = {};

      for (var attributeName in attributes) {
        var attribute = attributes[attributeName];

        var newAttribute = this._createAttribute(attributeName, attribute, extraProps);

        newAttributes[attributeName] = newAttribute;
      }

      Object.assign(this.attributes, newAttributes);

      this._mapUpdateTriggersToAttributes();
    }
  }, {
    key: "_createAttribute",
    value: function _createAttribute(name, attribute, extraProps) {
      var props = {
        id: name,
        constant: attribute.constant || false,
        isIndexed: attribute.isIndexed || attribute.elements,
        size: attribute.elements && 1 || attribute.size,
        value: attribute.value || null,
        divisor: attribute.instanced || extraProps.instanced ? 1 : attribute.divisor
      };
      return new Attribute(this.gl, Object.assign({}, attribute, props));
    }
  }, {
    key: "_mapUpdateTriggersToAttributes",
    value: function _mapUpdateTriggersToAttributes() {
      var _this = this;

      var triggers = {};

      var _loop = function _loop(attributeName) {
        var attribute = _this.attributes[attributeName];
        attribute.getUpdateTriggers().forEach(function (triggerName) {
          if (!triggers[triggerName]) {
            triggers[triggerName] = [];
          }

          triggers[triggerName].push(attributeName);
        });
      };

      for (var attributeName in this.attributes) {
        _loop(attributeName);
      }

      this.updateTriggers = triggers;
    }
  }, {
    key: "_invalidateTrigger",
    value: function _invalidateTrigger(triggerName, dataRange) {
      var attributes = this.attributes,
          updateTriggers = this.updateTriggers;
      var invalidatedAttributes = updateTriggers[triggerName];

      if (invalidatedAttributes) {
        invalidatedAttributes.forEach(function (name) {
          var attribute = attributes[name];

          if (attribute) {
            attribute.setNeedsUpdate(attribute.id, dataRange);
          }
        });
      }

      return invalidatedAttributes;
    }
  }, {
    key: "_updateAttribute",
    value: function _updateAttribute(opts) {
      var attribute = opts.attribute,
          numInstances = opts.numInstances;
      debug(TRACE_ATTRIBUTE_UPDATE_START, attribute);

      if (attribute.allocate(numInstances)) {
        debug(TRACE_ATTRIBUTE_ALLOCATE, attribute, numInstances);
      }

      var updated = attribute.updateBuffer(opts);

      if (updated) {
        this.needsRedraw = true;
        debug(TRACE_ATTRIBUTE_UPDATE_END, attribute, numInstances);
      }
    }
  }]);

  return AttributeManager;
}();

export { AttributeManager as default };
//# sourceMappingURL=attribute-manager.js.map