import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
var defaultStyle = {
  zIndex: 1,
  position: 'absolute',
  pointerEvents: 'none',
  color: '#a0a7b4',
  backgroundColor: '#29323c',
  padding: '10px',
  top: 0,
  left: 0,
  display: 'none'
};

var Tooltip = function () {
  function Tooltip(canvas) {
    _classCallCheck(this, Tooltip);

    var canvasParent = canvas.parentElement;

    if (canvasParent) {
      this.el = document.createElement('div');
      this.el.className = 'deck-tooltip';
      Object.assign(this.el.style, defaultStyle);
      canvasParent.appendChild(this.el);
    }
  }

  _createClass(Tooltip, [{
    key: "setTooltip",
    value: function setTooltip(displayInfo, x, y) {
      var el = this.el;

      if (typeof displayInfo === 'string') {
        el.innerText = displayInfo;
      } else if (!displayInfo) {
        el.style.display = 'none';
        return;
      } else {
        if ('text' in displayInfo) {
          el.innerText = displayInfo.text;
        }

        if ('html' in displayInfo) {
          el.innerHTML = displayInfo.html;
        }

        if ('className' in displayInfo) {
          el.className = displayInfo.className;
        }

        Object.assign(el.style, displayInfo.style);
      }

      el.style.display = 'block';
      el.style.transform = "translate(".concat(x, "px, ").concat(y, "px)");
    }
  }, {
    key: "remove",
    value: function remove() {
      if (this.el) {
        this.el.remove();
      }
    }
  }]);

  return Tooltip;
}();

export { Tooltip as default };
//# sourceMappingURL=tooltip.js.map