import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/esm/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/esm/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/esm/inherits";
import Pass from './pass';
import { clear, setParameters, withParameters, cssToDeviceRatio } from '@luma.gl/core';
import log from '../utils/log';

var LayersPass = function (_Pass) {
  _inherits(LayersPass, _Pass);

  function LayersPass() {
    _classCallCheck(this, LayersPass);

    return _possibleConstructorReturn(this, _getPrototypeOf(LayersPass).apply(this, arguments));
  }

  _createClass(LayersPass, [{
    key: "render",
    value: function render(props) {
      var gl = this.gl;
      setParameters(gl, {
        framebuffer: props.target
      });
      return this._drawLayers(props);
    }
  }, {
    key: "_drawLayers",
    value: function _drawLayers(props) {
      var viewports = props.viewports,
          views = props.views,
          onViewportActive = props.onViewportActive,
          _props$clearCanvas = props.clearCanvas,
          clearCanvas = _props$clearCanvas === void 0 ? true : _props$clearCanvas;
      var gl = this.gl;

      if (clearCanvas) {
        clearGLCanvas(gl);
      }

      var renderStats = [];
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = viewports[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var viewportOrDescriptor = _step.value;
          var viewport = viewportOrDescriptor.viewport || viewportOrDescriptor;
          var view = views && views[viewport.id];
          onViewportActive(viewport);

          var drawLayerParams = this._getDrawLayerParams(viewport, props);

          props.view = view;
          var subViewports = viewport.subViewports || [viewport];
          var _iteratorNormalCompletion2 = true;
          var _didIteratorError2 = false;
          var _iteratorError2 = undefined;

          try {
            for (var _iterator2 = subViewports[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
              var subViewport = _step2.value;
              props.viewport = subViewport;

              var stats = this._drawLayersInViewport(gl, props, drawLayerParams);

              renderStats.push(stats);
            }
          } catch (err) {
            _didIteratorError2 = true;
            _iteratorError2 = err;
          } finally {
            try {
              if (!_iteratorNormalCompletion2 && _iterator2["return"] != null) {
                _iterator2["return"]();
              }
            } finally {
              if (_didIteratorError2) {
                throw _iteratorError2;
              }
            }
          }
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator["return"] != null) {
            _iterator["return"]();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      return renderStats;
    }
  }, {
    key: "_getDrawLayerParams",
    value: function _getDrawLayerParams(viewport, _ref) {
      var layers = _ref.layers,
          _ref$pass = _ref.pass,
          pass = _ref$pass === void 0 ? 'unknown' : _ref$pass,
          layerFilter = _ref.layerFilter,
          effects = _ref.effects,
          moduleParameters = _ref.moduleParameters;
      var drawLayerParams = [];
      var indexResolver = layerIndexResolver();

      for (var layerIndex = 0; layerIndex < layers.length; layerIndex++) {
        var layer = layers[layerIndex];

        var shouldDrawLayer = this._shouldDrawLayer(layer, viewport, pass, layerFilter);

        var layerRenderIndex = indexResolver(layer, shouldDrawLayer);
        var layerParam = {
          shouldDrawLayer: shouldDrawLayer,
          layerRenderIndex: layerRenderIndex
        };

        if (shouldDrawLayer) {
          layerParam.moduleParameters = this._getModuleParameters(layer, effects, pass, moduleParameters);
          layerParam.layerParameters = this.getLayerParameters(layer, layerIndex);
        }

        drawLayerParams[layerIndex] = layerParam;
      }

      return drawLayerParams;
    }
  }, {
    key: "_drawLayersInViewport",
    value: function _drawLayersInViewport(gl, _ref2, drawLayerParams) {
      var layers = _ref2.layers,
          onError = _ref2.onError,
          viewport = _ref2.viewport,
          view = _ref2.view;
      var glViewport = getGLViewport(gl, {
        viewport: viewport
      });

      if (view && view.props.clear) {
        var clearOpts = view.props.clear === true ? {
          color: true,
          depth: true
        } : view.props.clear;
        withParameters(gl, {
          scissorTest: true,
          scissor: glViewport
        }, function () {
          return clear(gl, clearOpts);
        });
      }

      var renderStatus = {
        totalCount: layers.length,
        visibleCount: 0,
        compositeCount: 0,
        pickableCount: 0
      };
      setParameters(gl, {
        viewport: glViewport
      });

      for (var layerIndex = 0; layerIndex < layers.length; layerIndex++) {
        var layer = layers[layerIndex];
        var _drawLayerParams$laye = drawLayerParams[layerIndex],
            shouldDrawLayer = _drawLayerParams$laye.shouldDrawLayer,
            layerRenderIndex = _drawLayerParams$laye.layerRenderIndex,
            moduleParameters = _drawLayerParams$laye.moduleParameters,
            layerParameters = _drawLayerParams$laye.layerParameters;

        if (shouldDrawLayer && layer.props.pickable) {
          renderStatus.pickableCount++;
        }

        if (layer.isComposite) {
          renderStatus.compositeCount++;
        } else if (shouldDrawLayer) {
          renderStatus.visibleCount++;
          moduleParameters.viewport = viewport;

          try {
            layer.drawLayer({
              moduleParameters: moduleParameters,
              uniforms: {
                layerIndex: layerRenderIndex
              },
              parameters: layerParameters
            });
          } catch (err) {
            if (onError) {
              onError(err, layer);
            } else {
              log.error("error during drawing of ".concat(layer), err)();
            }
          }
        }
      }

      return renderStatus;
    }
  }, {
    key: "shouldDrawLayer",
    value: function shouldDrawLayer(layer) {
      return true;
    }
  }, {
    key: "getModuleParameters",
    value: function getModuleParameters(layer, effects) {
      return null;
    }
  }, {
    key: "getLayerParameters",
    value: function getLayerParameters(layer, layerIndex) {
      return layer.props.parameters;
    }
  }, {
    key: "_shouldDrawLayer",
    value: function _shouldDrawLayer(layer, viewport, pass, layerFilter) {
      var shouldDrawLayer = this.shouldDrawLayer(layer) && layer.props.visible;

      if (shouldDrawLayer && layerFilter) {
        shouldDrawLayer = layerFilter({
          layer: layer,
          viewport: viewport,
          isPicking: pass.startsWith('picking'),
          renderPass: pass
        });
      }

      if (shouldDrawLayer) {
        layer.activateViewport(viewport);
      }

      return shouldDrawLayer;
    }
  }, {
    key: "_getModuleParameters",
    value: function _getModuleParameters(layer, effects, pass, overrides) {
      var moduleParameters = Object.assign(Object.create(layer.props), {
        autoWrapLongitude: layer.wrapLongitude,
        viewport: layer.context.viewport,
        mousePosition: layer.context.mousePosition,
        pickingActive: 0,
        devicePixelRatio: cssToDeviceRatio(this.gl)
      });

      if (effects) {
        var _iteratorNormalCompletion3 = true;
        var _didIteratorError3 = false;
        var _iteratorError3 = undefined;

        try {
          for (var _iterator3 = effects[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
            var effect = _step3.value;
            Object.assign(moduleParameters, effect.getModuleParameters(layer));
          }
        } catch (err) {
          _didIteratorError3 = true;
          _iteratorError3 = err;
        } finally {
          try {
            if (!_iteratorNormalCompletion3 && _iterator3["return"] != null) {
              _iterator3["return"]();
            }
          } finally {
            if (_didIteratorError3) {
              throw _iteratorError3;
            }
          }
        }
      }

      return Object.assign(moduleParameters, this.getModuleParameters(layer, effects), overrides);
    }
  }]);

  return LayersPass;
}(Pass);

export { LayersPass as default };
export function layerIndexResolver() {
  var startIndex = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
  var layerIndices = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var resolvers = {};
  return function (layer, isDrawn) {
    var indexOverride = layer.props._offset;
    var layerId = layer.id;
    var parentId = layer.parent && layer.parent.id;
    var index;

    if (parentId in resolvers) {
      var resolver = resolvers[parentId] = resolvers[parentId] || layerIndexResolver(layerIndices[parentId], layerIndices);
      index = resolver(layer, isDrawn);
      resolvers[layerId] = resolver;
    } else if (Number.isFinite(indexOverride)) {
      index = indexOverride + (layerIndices[parentId] || 0);
      resolvers[layerId] = null;
    } else {
      index = startIndex;
    }

    if (isDrawn && index >= startIndex) {
      startIndex = index + 1;
    }

    layerIndices[layerId] = index;
    return index;
  };
}

function getGLViewport(gl, _ref3) {
  var viewport = _ref3.viewport;
  var height = gl.canvas ? gl.canvas.clientHeight || gl.canvas.height : 100;
  var dimensions = viewport;
  var pixelRatio = cssToDeviceRatio(gl);
  return [dimensions.x * pixelRatio, (height - dimensions.y - dimensions.height) * pixelRatio, dimensions.width * pixelRatio, dimensions.height * pixelRatio];
}

function clearGLCanvas(gl) {
  var width = gl.drawingBufferWidth;
  var height = gl.drawingBufferHeight;
  setParameters(gl, {
    viewport: [0, 0, width, height]
  });
  gl.clear(16384 | 256);
}
//# sourceMappingURL=layers-pass.js.map