import { fp32 } from '@luma.gl/core';
import projectShader from './project.glsl';
import { getUniformsFromViewport } from './viewport-uniforms';
var INITIAL_MODULE_OPTIONS = {};

function getUniforms() {
  var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : INITIAL_MODULE_OPTIONS;

  if (opts.viewport) {
    return getUniformsFromViewport(opts);
  }

  return {};
}

export default {
  name: 'project',
  dependencies: [fp32],
  vs: projectShader,
  getUniforms: getUniforms
};
//# sourceMappingURL=project.js.map