import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/esm/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/esm/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/esm/inherits";
import TransitionInterpolator from './transition-interpolator';
import { lerp } from 'math.gl';
var DEFAULT_PROPS = ['longitude', 'latitude', 'zoom', 'bearing', 'pitch'];
var DEFAULT_REQUIRED_PROPS = ['longitude', 'latitude', 'zoom'];

var LinearInterpolator = function (_TransitionInterpolat) {
  _inherits(LinearInterpolator, _TransitionInterpolat);

  function LinearInterpolator(transitionProps) {
    _classCallCheck(this, LinearInterpolator);

    return _possibleConstructorReturn(this, _getPrototypeOf(LinearInterpolator).call(this, transitionProps || {
      compare: DEFAULT_PROPS,
      extract: DEFAULT_PROPS,
      required: DEFAULT_REQUIRED_PROPS
    }));
  }

  _createClass(LinearInterpolator, [{
    key: "interpolateProps",
    value: function interpolateProps(startProps, endProps, t) {
      var viewport = {};

      for (var key in endProps) {
        viewport[key] = lerp(startProps[key] || 0, endProps[key] || 0, t);
      }

      return viewport;
    }
  }]);

  return LinearInterpolator;
}(TransitionInterpolator);

export { LinearInterpolator as default };
//# sourceMappingURL=linear-interpolator.js.map