"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.patternShaders = void 0;

var _core = require("@deck.gl/core");

var patternVs = "\n#ifdef NON_INSTANCED_MODEL\n  #define FILL_PATTERN_FRAME_ATTRIB fillPatternFrames\n  #define FILL_PATTERN_SCALE_ATTRIB fillPatternScales\n  #define FILL_PATTERN_OFFSET_ATTRIB fillPatternOffsets\n#else\n  #define FILL_PATTERN_FRAME_ATTRIB instanceFillPatternFrames\n  #define FILL_PATTERN_SCALE_ATTRIB instanceFillPatternScales\n  #define FILL_PATTERN_OFFSET_ATTRIB instanceFillPatternOffsets\n#endif\n\nattribute vec4 FILL_PATTERN_FRAME_ATTRIB;\nattribute float FILL_PATTERN_SCALE_ATTRIB;\nattribute vec2 FILL_PATTERN_OFFSET_ATTRIB;\n\nuniform bool fill_patternEnabled;\nuniform vec2 fill_patternTextureSize;\n\nvarying vec2 fill_uv;\nvarying vec4 fill_patternBounds;\nvarying vec3 fill_patternPlacement;\n";
var patternFs = "\nuniform bool fill_patternEnabled;\nuniform bool fill_patternMask;\nuniform sampler2D fill_patternTexture;\nuniform vec2 fill_uvCoordinateOrigin;\n\nvarying vec4 fill_patternBounds;\nvarying vec3 fill_patternPlacement;\nvarying vec2 fill_uv;\n\nconst float FILL_UV_SCALE = 512.0 / 40000000.0;\n";
var inject = {
  'vs:DECKGL_FILTER_GL_POSITION': "\n    fill_uv = geometry.position.xy;\n  ",
  'vs:DECKGL_FILTER_COLOR': "\n    if (fill_patternEnabled) {\n      fill_patternBounds = FILL_PATTERN_FRAME_ATTRIB / vec4(fill_patternTextureSize, fill_patternTextureSize);\n      fill_patternPlacement.xy = FILL_PATTERN_OFFSET_ATTRIB;\n      fill_patternPlacement.z = FILL_PATTERN_SCALE_ATTRIB * FILL_PATTERN_FRAME_ATTRIB.w;\n    }\n  ",
  'fs:DECKGL_FILTER_COLOR': "\n    if (fill_patternEnabled) {\n      float scale = FILL_UV_SCALE * fill_patternPlacement.z;\n      vec2 patternUV = mod(mod(fill_uvCoordinateOrigin, scale) + fill_uv, scale) / scale;\n      patternUV = mod(fill_patternPlacement.xy + patternUV, 1.0);\n\n      vec2 texCoords = fill_patternBounds.xy + fill_patternBounds.zw * patternUV;\n      texCoords.y = 1.0 - texCoords.y;\n\n      vec4 patternColor = texture2D(fill_patternTexture, texCoords);\n      if (fill_patternMask) {\n        color.a *= patternColor.a;\n      } else {\n        color.rgb = patternColor.rgb;\n      }\n    }\n  "
};

function getPatternUniforms() {
  var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var uniforms = arguments.length > 1 ? arguments[1] : undefined;

  if ('fillPatternTexture' in opts) {
    var fillPatternTexture = opts.fillPatternTexture;
    return {
      fill_patternTexture: fillPatternTexture,
      fill_patternTextureSize: [fillPatternTexture.width, fillPatternTexture.height]
    };
  }

  if (opts.viewport) {
    var viewport = opts.viewport,
        _opts$fillPatternMask = opts.fillPatternMask,
        fillPatternMask = _opts$fillPatternMask === void 0 ? true : _opts$fillPatternMask,
        _opts$fillPatternEnab = opts.fillPatternEnabled,
        fillPatternEnabled = _opts$fillPatternEnab === void 0 ? true : _opts$fillPatternEnab;
    var project_uCoordinateOrigin = uniforms.project_uCoordinateOrigin,
        project_uCoordinateSystem = uniforms.project_uCoordinateSystem;
    var coordinateOriginCommon = project_uCoordinateSystem === _core.COORDINATE_SYSTEM.CARTESIAN ? project_uCoordinateOrigin : viewport.projectPosition(project_uCoordinateOrigin);
    return {
      fill_uvCoordinateOrigin: coordinateOriginCommon.slice(0, 2),
      fill_patternMask: fillPatternMask,
      fill_patternEnabled: fillPatternEnabled
    };
  }

  return {};
}

var patternShaders = {
  name: 'fill-pattern',
  vs: patternVs,
  fs: patternFs,
  inject: inject,
  dependencies: [_core.project],
  getUniforms: getPatternUniforms
};
exports.patternShaders = patternShaders;
//# sourceMappingURL=shaders.glsl.js.map