"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _core = require("@deck.gl/core");

var _shaders = require("./shaders.glsl");

var defaultProps = {
  getDashArray: {
    type: 'accessor',
    value: [0, 0]
  },
  getOffset: {
    type: 'accessor',
    value: 0
  },
  dashJustified: false
};

var PathStyleExtension = function (_LayerExtension) {
  (0, _inherits2["default"])(PathStyleExtension, _LayerExtension);

  function PathStyleExtension() {
    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        _ref$dash = _ref.dash,
        dash = _ref$dash === void 0 ? false : _ref$dash,
        _ref$offset = _ref.offset,
        offset = _ref$offset === void 0 ? false : _ref$offset;

    (0, _classCallCheck2["default"])(this, PathStyleExtension);
    return (0, _possibleConstructorReturn2["default"])(this, (0, _getPrototypeOf2["default"])(PathStyleExtension).call(this, {
      dash: dash,
      offset: offset
    }));
  }

  (0, _createClass2["default"])(PathStyleExtension, [{
    key: "isEnabled",
    value: function isEnabled(layer) {
      return layer.state.pathTesselator;
    }
  }, {
    key: "getShaders",
    value: function getShaders(extension) {
      if (!extension.isEnabled(this)) {
        return null;
      }

      var result = {};

      if (extension.opts.dash) {
        result = (0, _core._mergeShaders)(result, _shaders.dashShaders);
      }

      if (extension.opts.offset) {
        result = (0, _core._mergeShaders)(result, _shaders.offsetShaders);
      }

      return result;
    }
  }, {
    key: "initializeState",
    value: function initializeState(context, extension) {
      var attributeManager = this.getAttributeManager();

      if (!attributeManager || !extension.isEnabled(this)) {
        return;
      }

      extension.enabled = true;

      if (extension.opts.dash) {
        attributeManager.addInstanced({
          instanceDashArrays: {
            size: 2,
            accessor: 'getDashArray'
          }
        });
      }

      if (extension.opts.offset) {
        attributeManager.addInstanced({
          instanceOffsets: {
            size: 1,
            accessor: 'getOffset'
          }
        });
      }
    }
  }, {
    key: "updateState",
    value: function updateState(params, extension) {
      if (!extension.isEnabled(this)) {
        return;
      }

      var uniforms = {};

      if (extension.opts.dash) {
        uniforms.dashAlignMode = this.props.dashJustified ? 1 : 0;
      }

      this.state.model.setUniforms(uniforms);
    }
  }]);
  return PathStyleExtension;
}(_core.LayerExtension);

exports["default"] = PathStyleExtension;
PathStyleExtension.extensionName = 'PathStyleExtension';
PathStyleExtension.defaultProps = defaultProps;
//# sourceMappingURL=path-style.js.map