"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.offsetShaders = exports.dashShaders = void 0;
var dashShaders = {
  inject: {
    'vs:#decl': "\nattribute vec2 instanceDashArrays;\nvarying vec2 vDashArray;\n",
    'vs:#main-end': "\nvDashArray = instanceDashArrays;\n",
    'fs:#decl': "\nuniform float dashAlignMode;\nvarying vec2 vDashArray;\nfloat mod2(float a, float b) {\n  return a - floor(a / b) * b;\n}\n\nfloat round(float x) {\n  return floor(x + 0.5);\n}\n",
    'fs:#main-start': "\n  float solidLength = vDashArray.x;\n  float gapLength = vDashArray.y;\n  float unitLength = solidLength + gapLength;\n\n  if (unitLength > 0.0) {\n    unitLength = mix(\n      unitLength,\n      vPathLength / round(vPathLength / unitLength),\n      dashAlignMode\n    );\n\n    float offset = dashAlignMode * solidLength / 2.0;\n\n    if (\n      gapLength > 0.0 &&\n      vPathPosition.y >= 0.0 &&\n      vPathPosition.y <= vPathLength &&\n      mod2(vPathPosition.y + offset, unitLength) > solidLength\n    ) {\n      discard;\n    }\n  }  \n"
  }
};
exports.dashShaders = dashShaders;
var offsetShaders = {
  inject: {
    'vs:#decl': "\nattribute float instanceOffsets;\n",
    'vs:DECKGL_FILTER_SIZE': "\n  float offsetWidth = abs(instanceOffsets * 2.0) + 1.0;\n  size *= offsetWidth;\n",
    'vCornerOffset = offsetVec;': "\n  float offsetWidth = abs(instanceOffsets * 2.0) + 1.0;\n  vec2 offsetCenter = -instanceOffsets * (isCap ? perp : miterVec * miterSize) * 2.0;\n  vCornerOffset = vCornerOffset * offsetWidth - offsetCenter;\n",
    'fs:#main-start': "\n  float isInside;\n  isInside = step(-1.0, vPathPosition.x) * step(vPathPosition.x, 1.0);\n  if (isInside == 0.0) {\n    discard;\n  }\n"
  }
};
exports.offsetShaders = offsetShaders;
//# sourceMappingURL=shaders.glsl.js.map