import { LayerExtension, _mergeShaders as mergeShaders } from '@deck.gl/core';
import { dashShaders, offsetShaders } from './shaders.glsl';
const defaultProps = {
  getDashArray: {
    type: 'accessor',
    value: [0, 0]
  },
  getOffset: {
    type: 'accessor',
    value: 0
  },
  dashJustified: false
};
export default class PathStyleExtension extends LayerExtension {
  constructor({
    dash = false,
    offset = false
  } = {}) {
    super({
      dash,
      offset
    });
  }

  isEnabled(layer) {
    return layer.state.pathTesselator;
  }

  getShaders(extension) {
    if (!extension.isEnabled(this)) {
      return null;
    }

    let result = {};

    if (extension.opts.dash) {
      result = mergeShaders(result, dashShaders);
    }

    if (extension.opts.offset) {
      result = mergeShaders(result, offsetShaders);
    }

    return result;
  }

  initializeState(context, extension) {
    const attributeManager = this.getAttributeManager();

    if (!attributeManager || !extension.isEnabled(this)) {
      return;
    }

    extension.enabled = true;

    if (extension.opts.dash) {
      attributeManager.addInstanced({
        instanceDashArrays: {
          size: 2,
          accessor: 'getDashArray'
        }
      });
    }

    if (extension.opts.offset) {
      attributeManager.addInstanced({
        instanceOffsets: {
          size: 1,
          accessor: 'getOffset'
        }
      });
    }
  }

  updateState(params, extension) {
    if (!extension.isEnabled(this)) {
      return;
    }

    const uniforms = {};

    if (extension.opts.dash) {
      uniforms.dashAlignMode = this.props.dashJustified ? 1 : 0;
    }

    this.state.model.setUniforms(uniforms);
  }

}
PathStyleExtension.extensionName = 'PathStyleExtension';
PathStyleExtension.defaultProps = defaultProps;
//# sourceMappingURL=path-style.js.map