import { fp64 } from '@luma.gl/shadertools';
var fp64ify = fp64.fp64ify,
    fp64ifyMatrix4 = fp64.fp64ifyMatrix4;
import { project, _memoize as memoize } from '@deck.gl/core';
import project64Shader from './project64.glsl';
export default {
  name: 'project64',
  dependencies: [project, fp64],
  vs: project64Shader,
  getUniforms: getUniforms
};
var DEFAULT_MODULE_OPTIONS = {};
var getMemoizedUniforms = memoize(calculateUniforms);

function getUniforms() {
  var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : DEFAULT_MODULE_OPTIONS;

  if (opts.viewport) {
    var _opts$viewport = opts.viewport,
        viewProjectionMatrix = _opts$viewport.viewProjectionMatrix,
        scale = _opts$viewport.scale;
    return getMemoizedUniforms({
      viewProjectionMatrix: viewProjectionMatrix,
      scale: scale
    });
  }

  return {};
}

function calculateUniforms(_ref) {
  var viewProjectionMatrix = _ref.viewProjectionMatrix,
      scale = _ref.scale;
  var glViewProjectionMatrixFP64 = fp64ifyMatrix4(viewProjectionMatrix);
  var scaleFP64 = fp64ify(scale);
  return {
    project_uViewProjectionMatrixFP64: glViewProjectionMatrixFP64,
    project64_uViewProjectionMatrix: glViewProjectionMatrixFP64,
    project64_uScale: scaleFP64
  };
}
//# sourceMappingURL=project64.js.map