"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));

var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _core = require("@deck.gl/core");

var _core2 = require("@luma.gl/core");

var _shaders = require("./shaders.glsl");

var _DEFAULT_TEXTURE_PARA;

var defaultProps = {
  fillPatternEnabled: true,
  fillPatternAtlas: null,
  fillPatternMapping: null,
  fillPatternMask: true,
  getFillPattern: {
    type: 'accessor',
    value: function value(d) {
      return d.pattern;
    }
  },
  getFillPatternScale: {
    type: 'accessor',
    value: 1
  },
  getFillPatternOffset: {
    type: 'accessor',
    value: [0, 0]
  }
};
var DEFAULT_TEXTURE_PARAMETERS = (_DEFAULT_TEXTURE_PARA = {}, (0, _defineProperty2["default"])(_DEFAULT_TEXTURE_PARA, 10241, 9729), (0, _defineProperty2["default"])(_DEFAULT_TEXTURE_PARA, 10240, 9729), (0, _defineProperty2["default"])(_DEFAULT_TEXTURE_PARA, 10242, 33071), (0, _defineProperty2["default"])(_DEFAULT_TEXTURE_PARA, 10243, 33071), _DEFAULT_TEXTURE_PARA);

var FillStyleExtension = function (_LayerExtension) {
  (0, _inherits2["default"])(FillStyleExtension, _LayerExtension);

  function FillStyleExtension() {
    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        _ref$pattern = _ref.pattern,
        pattern = _ref$pattern === void 0 ? false : _ref$pattern;

    (0, _classCallCheck2["default"])(this, FillStyleExtension);
    return (0, _possibleConstructorReturn2["default"])(this, (0, _getPrototypeOf2["default"])(FillStyleExtension).call(this, {
      pattern: pattern
    }));
  }

  (0, _createClass2["default"])(FillStyleExtension, [{
    key: "isEnabled",
    value: function isEnabled(layer) {
      return layer.getAttributeManager() && !layer.state.pathTesselator;
    }
  }, {
    key: "getShaders",
    value: function getShaders(extension) {
      if (!extension.isEnabled(this)) {
        return null;
      }

      return {
        modules: [extension.opts.pattern && _shaders.patternShaders].filter(Boolean)
      };
    }
  }, {
    key: "initializeState",
    value: function initializeState(context, extension) {
      if (!extension.isEnabled(this)) {
        return;
      }

      var attributeManager = this.getAttributeManager();

      if (extension.opts.pattern) {
        attributeManager.add({
          fillPatternFrames: {
            size: 4,
            accessor: 'getFillPattern',
            transform: extension.getPatternFrame.bind(this),
            shaderAttributes: {
              fillPatternFrames: {
                divisor: 0
              },
              instanceFillPatternFrames: {
                divisor: 1
              }
            }
          },
          fillPatternScales: {
            size: 1,
            accessor: 'getFillPatternScale',
            defaultValue: 1,
            shaderAttributes: {
              fillPatternScales: {
                divisor: 0
              },
              instanceFillPatternScales: {
                divisor: 1
              }
            }
          },
          fillPatternOffsets: {
            size: 2,
            accessor: 'getFillPatternOffset',
            shaderAttributes: {
              fillPatternOffsets: {
                divisor: 0
              },
              instanceFillPatternOffsets: {
                divisor: 1
              }
            }
          }
        });
      }

      this.setState({
        emptyTexture: new _core2.Texture2D(this.context.gl, {
          data: new Uint8Array(4),
          width: 1,
          height: 1
        })
      });
    }
  }, {
    key: "updateState",
    value: function updateState(_ref2, extension) {
      var props = _ref2.props,
          oldProps = _ref2.oldProps;

      if (!extension.isEnabled(this)) {
        return;
      }

      if (props.fillPatternAtlas && props.fillPatternAtlas !== oldProps.fillPatternAtlas) {
        extension.loadPatternAtlas.call(this, props);
      }

      if (props.fillPatternMapping && props.fillPatternMapping !== oldProps.fillPatternMapping) {
        extension.loadPatternMapping.call(this, props);
      }
    }
  }, {
    key: "draw",
    value: function draw(params, extension) {
      if (!extension.isEnabled(this)) {
        return;
      }

      var patternTexture = this.state.patternTexture;
      this.setModuleParameters({
        fillPatternTexture: patternTexture || this.state.emptyTexture
      });
    }
  }, {
    key: "finalizeState",
    value: function finalizeState() {
      var _this$state = this.state,
          patternTexture = _this$state.patternTexture,
          emptyTexture = _this$state.emptyTexture;

      if (patternTexture) {
        patternTexture["delete"]();
      }

      if (emptyTexture) {
        emptyTexture["delete"]();
      }
    }
  }, {
    key: "loadPatternAtlas",
    value: function () {
      var _loadPatternAtlas = (0, _asyncToGenerator2["default"])(_regenerator["default"].mark(function _callee(_ref3) {
        var fillPatternAtlas, fetch, image, patternTexture;
        return _regenerator["default"].wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                fillPatternAtlas = _ref3.fillPatternAtlas, fetch = _ref3.fetch;

                if (this.state.patternTexture) {
                  this.state.patternTexture["delete"]();
                }

                this.setState({
                  patternTexture: null
                });
                image = fillPatternAtlas;

                if (!(typeof image === 'string')) {
                  _context.next = 8;
                  break;
                }

                _context.next = 7;
                return fetch(image, {
                  propName: 'fillPatternAtlas',
                  layer: this
                });

              case 7:
                image = _context.sent;

              case 8:
                patternTexture = image instanceof _core2.Texture2D ? image : new _core2.Texture2D(this.context.gl, {
                  data: image,
                  parameters: DEFAULT_TEXTURE_PARAMETERS
                });
                this.setState({
                  patternTexture: patternTexture
                });

              case 10:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this);
      }));

      function loadPatternAtlas(_x) {
        return _loadPatternAtlas.apply(this, arguments);
      }

      return loadPatternAtlas;
    }()
  }, {
    key: "loadPatternMapping",
    value: function () {
      var _loadPatternMapping = (0, _asyncToGenerator2["default"])(_regenerator["default"].mark(function _callee2(_ref4) {
        var fillPatternMapping, fetch, patternMapping;
        return _regenerator["default"].wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                fillPatternMapping = _ref4.fillPatternMapping, fetch = _ref4.fetch;
                this.setState({
                  patternMapping: null
                });
                patternMapping = fillPatternMapping;

                if (!(typeof patternMapping === 'string')) {
                  _context2.next = 7;
                  break;
                }

                _context2.next = 6;
                return fetch(patternMapping, {
                  propName: 'fillPatternMapping',
                  layer: this
                });

              case 6:
                patternMapping = _context2.sent;

              case 7:
                this.setState({
                  patternMapping: patternMapping
                });
                this.getAttributeManager().invalidate('getFillPattern');
                this.setNeedsUpdate();

              case 10:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2, this);
      }));

      function loadPatternMapping(_x2) {
        return _loadPatternMapping.apply(this, arguments);
      }

      return loadPatternMapping;
    }()
  }, {
    key: "getPatternFrame",
    value: function getPatternFrame(name) {
      var patternMapping = this.state.patternMapping;
      var def = patternMapping && patternMapping[name];
      return def ? [def.x, def.y, def.width, def.height] : [0, 0, 0, 0];
    }
  }]);
  return FillStyleExtension;
}(_core.LayerExtension);

exports["default"] = FillStyleExtension;
FillStyleExtension.extensionName = 'FillStyleExtension';
FillStyleExtension.defaultProps = defaultProps;
//# sourceMappingURL=fill-style.js.map