import { fp64 } from '@luma.gl/shadertools';
const {
  fp64ify,
  fp64ifyMatrix4
} = fp64;
import { project, _memoize as memoize } from '@deck.gl/core';
import project64Shader from './project64.glsl';
export default {
  name: 'project64',
  dependencies: [project, fp64],
  vs: project64Shader,
  getUniforms
};
const DEFAULT_MODULE_OPTIONS = {};
const getMemoizedUniforms = memoize(calculateUniforms);

function getUniforms(opts = DEFAULT_MODULE_OPTIONS) {
  if (opts.viewport) {
    const {
      viewProjectionMatrix,
      scale
    } = opts.viewport;
    return getMemoizedUniforms({
      viewProjectionMatrix,
      scale
    });
  }

  return {};
}

function calculateUniforms({
  viewProjectionMatrix,
  scale
}) {
  const glViewProjectionMatrixFP64 = fp64ifyMatrix4(viewProjectionMatrix);
  const scaleFP64 = fp64ify(scale);
  return {
    project_uViewProjectionMatrixFP64: glViewProjectionMatrixFP64,
    project64_uViewProjectionMatrix: glViewProjectionMatrixFP64,
    project64_uScale: scaleFP64
  };
}
//# sourceMappingURL=project64.js.map