import _regeneratorRuntime from "@babel/runtime/regenerator";
import _asyncToGenerator from "@babel/runtime/helpers/esm/asyncToGenerator";
import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/esm/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/esm/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/esm/inherits";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";

var _DEFAULT_TEXTURE_PARA;

import { LayerExtension } from '@deck.gl/core';
import { Texture2D } from '@luma.gl/core';
import { patternShaders } from './shaders.glsl';
var defaultProps = {
  fillPatternEnabled: true,
  fillPatternAtlas: null,
  fillPatternMapping: null,
  fillPatternMask: true,
  getFillPattern: {
    type: 'accessor',
    value: function value(d) {
      return d.pattern;
    }
  },
  getFillPatternScale: {
    type: 'accessor',
    value: 1
  },
  getFillPatternOffset: {
    type: 'accessor',
    value: [0, 0]
  }
};
var DEFAULT_TEXTURE_PARAMETERS = (_DEFAULT_TEXTURE_PARA = {}, _defineProperty(_DEFAULT_TEXTURE_PARA, 10241, 9729), _defineProperty(_DEFAULT_TEXTURE_PARA, 10240, 9729), _defineProperty(_DEFAULT_TEXTURE_PARA, 10242, 33071), _defineProperty(_DEFAULT_TEXTURE_PARA, 10243, 33071), _DEFAULT_TEXTURE_PARA);

var FillStyleExtension = function (_LayerExtension) {
  _inherits(FillStyleExtension, _LayerExtension);

  function FillStyleExtension() {
    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        _ref$pattern = _ref.pattern,
        pattern = _ref$pattern === void 0 ? false : _ref$pattern;

    _classCallCheck(this, FillStyleExtension);

    return _possibleConstructorReturn(this, _getPrototypeOf(FillStyleExtension).call(this, {
      pattern: pattern
    }));
  }

  _createClass(FillStyleExtension, [{
    key: "isEnabled",
    value: function isEnabled(layer) {
      return layer.getAttributeManager() && !layer.state.pathTesselator;
    }
  }, {
    key: "getShaders",
    value: function getShaders(extension) {
      if (!extension.isEnabled(this)) {
        return null;
      }

      return {
        modules: [extension.opts.pattern && patternShaders].filter(Boolean)
      };
    }
  }, {
    key: "initializeState",
    value: function initializeState(context, extension) {
      if (!extension.isEnabled(this)) {
        return;
      }

      var attributeManager = this.getAttributeManager();

      if (extension.opts.pattern) {
        attributeManager.add({
          fillPatternFrames: {
            size: 4,
            accessor: 'getFillPattern',
            transform: extension.getPatternFrame.bind(this),
            shaderAttributes: {
              fillPatternFrames: {
                divisor: 0
              },
              instanceFillPatternFrames: {
                divisor: 1
              }
            }
          },
          fillPatternScales: {
            size: 1,
            accessor: 'getFillPatternScale',
            defaultValue: 1,
            shaderAttributes: {
              fillPatternScales: {
                divisor: 0
              },
              instanceFillPatternScales: {
                divisor: 1
              }
            }
          },
          fillPatternOffsets: {
            size: 2,
            accessor: 'getFillPatternOffset',
            shaderAttributes: {
              fillPatternOffsets: {
                divisor: 0
              },
              instanceFillPatternOffsets: {
                divisor: 1
              }
            }
          }
        });
      }

      this.setState({
        emptyTexture: new Texture2D(this.context.gl, {
          data: new Uint8Array(4),
          width: 1,
          height: 1
        })
      });
    }
  }, {
    key: "updateState",
    value: function updateState(_ref2, extension) {
      var props = _ref2.props,
          oldProps = _ref2.oldProps;

      if (!extension.isEnabled(this)) {
        return;
      }

      if (props.fillPatternAtlas && props.fillPatternAtlas !== oldProps.fillPatternAtlas) {
        extension.loadPatternAtlas.call(this, props);
      }

      if (props.fillPatternMapping && props.fillPatternMapping !== oldProps.fillPatternMapping) {
        extension.loadPatternMapping.call(this, props);
      }
    }
  }, {
    key: "draw",
    value: function draw(params, extension) {
      if (!extension.isEnabled(this)) {
        return;
      }

      var patternTexture = this.state.patternTexture;
      this.setModuleParameters({
        fillPatternTexture: patternTexture || this.state.emptyTexture
      });
    }
  }, {
    key: "finalizeState",
    value: function finalizeState() {
      var _this$state = this.state,
          patternTexture = _this$state.patternTexture,
          emptyTexture = _this$state.emptyTexture;

      if (patternTexture) {
        patternTexture["delete"]();
      }

      if (emptyTexture) {
        emptyTexture["delete"]();
      }
    }
  }, {
    key: "loadPatternAtlas",
    value: function () {
      var _loadPatternAtlas = _asyncToGenerator(_regeneratorRuntime.mark(function _callee(_ref3) {
        var fillPatternAtlas, fetch, image, patternTexture;
        return _regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                fillPatternAtlas = _ref3.fillPatternAtlas, fetch = _ref3.fetch;

                if (this.state.patternTexture) {
                  this.state.patternTexture["delete"]();
                }

                this.setState({
                  patternTexture: null
                });
                image = fillPatternAtlas;

                if (!(typeof image === 'string')) {
                  _context.next = 8;
                  break;
                }

                _context.next = 7;
                return fetch(image, {
                  propName: 'fillPatternAtlas',
                  layer: this
                });

              case 7:
                image = _context.sent;

              case 8:
                patternTexture = image instanceof Texture2D ? image : new Texture2D(this.context.gl, {
                  data: image,
                  parameters: DEFAULT_TEXTURE_PARAMETERS
                });
                this.setState({
                  patternTexture: patternTexture
                });

              case 10:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this);
      }));

      function loadPatternAtlas(_x) {
        return _loadPatternAtlas.apply(this, arguments);
      }

      return loadPatternAtlas;
    }()
  }, {
    key: "loadPatternMapping",
    value: function () {
      var _loadPatternMapping = _asyncToGenerator(_regeneratorRuntime.mark(function _callee2(_ref4) {
        var fillPatternMapping, fetch, patternMapping;
        return _regeneratorRuntime.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                fillPatternMapping = _ref4.fillPatternMapping, fetch = _ref4.fetch;
                this.setState({
                  patternMapping: null
                });
                patternMapping = fillPatternMapping;

                if (!(typeof patternMapping === 'string')) {
                  _context2.next = 7;
                  break;
                }

                _context2.next = 6;
                return fetch(patternMapping, {
                  propName: 'fillPatternMapping',
                  layer: this
                });

              case 6:
                patternMapping = _context2.sent;

              case 7:
                this.setState({
                  patternMapping: patternMapping
                });
                this.getAttributeManager().invalidate('getFillPattern');
                this.setNeedsUpdate();

              case 10:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2, this);
      }));

      function loadPatternMapping(_x2) {
        return _loadPatternMapping.apply(this, arguments);
      }

      return loadPatternMapping;
    }()
  }, {
    key: "getPatternFrame",
    value: function getPatternFrame(name) {
      var patternMapping = this.state.patternMapping;
      var def = patternMapping && patternMapping[name];
      return def ? [def.x, def.y, def.width, def.height] : [0, 0, 0, 0];
    }
  }]);

  return FillStyleExtension;
}(LayerExtension);

export { FillStyleExtension as default };
FillStyleExtension.extensionName = 'FillStyleExtension';
FillStyleExtension.defaultProps = defaultProps;
//# sourceMappingURL=fill-style.js.map