import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/esm/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/esm/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/esm/inherits";
import { LayerExtension, _mergeShaders as mergeShaders } from '@deck.gl/core';
import { dashShaders, offsetShaders } from './shaders.glsl';
var defaultProps = {
  getDashArray: {
    type: 'accessor',
    value: [0, 0]
  },
  getOffset: {
    type: 'accessor',
    value: 0
  },
  dashJustified: false
};

var PathStyleExtension = function (_LayerExtension) {
  _inherits(PathStyleExtension, _LayerExtension);

  function PathStyleExtension() {
    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        _ref$dash = _ref.dash,
        dash = _ref$dash === void 0 ? false : _ref$dash,
        _ref$offset = _ref.offset,
        offset = _ref$offset === void 0 ? false : _ref$offset;

    _classCallCheck(this, PathStyleExtension);

    return _possibleConstructorReturn(this, _getPrototypeOf(PathStyleExtension).call(this, {
      dash: dash,
      offset: offset
    }));
  }

  _createClass(PathStyleExtension, [{
    key: "isEnabled",
    value: function isEnabled(layer) {
      return layer.state.pathTesselator;
    }
  }, {
    key: "getShaders",
    value: function getShaders(extension) {
      if (!extension.isEnabled(this)) {
        return null;
      }

      var result = {};

      if (extension.opts.dash) {
        result = mergeShaders(result, dashShaders);
      }

      if (extension.opts.offset) {
        result = mergeShaders(result, offsetShaders);
      }

      return result;
    }
  }, {
    key: "initializeState",
    value: function initializeState(context, extension) {
      var attributeManager = this.getAttributeManager();

      if (!attributeManager || !extension.isEnabled(this)) {
        return;
      }

      extension.enabled = true;

      if (extension.opts.dash) {
        attributeManager.addInstanced({
          instanceDashArrays: {
            size: 2,
            accessor: 'getDashArray'
          }
        });
      }

      if (extension.opts.offset) {
        attributeManager.addInstanced({
          instanceOffsets: {
            size: 1,
            accessor: 'getOffset'
          }
        });
      }
    }
  }, {
    key: "updateState",
    value: function updateState(params, extension) {
      if (!extension.isEnabled(this)) {
        return;
      }

      var uniforms = {};

      if (extension.opts.dash) {
        uniforms.dashAlignMode = this.props.dashJustified ? 1 : 0;
      }

      this.state.model.setUniforms(uniforms);
    }
  }]);

  return PathStyleExtension;
}(LayerExtension);

export { PathStyleExtension as default };
PathStyleExtension.extensionName = 'PathStyleExtension';
PathStyleExtension.defaultProps = defaultProps;
//# sourceMappingURL=path-style.js.map