"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _core = require("@deck.gl/core");

var defaultProps = {
  clipBounds: [0, 0, 1, 1]
};
var shaderFunction = "\nuniform vec4 clip_bounds;\n\nbool clip_isInBounds(vec2 position) {\n  return position.x >= clip_bounds[0] && position.y >= clip_bounds[1] && position.x < clip_bounds[2] && position.y < clip_bounds[3];\n}\n";
var shaderModuleVs = {
  name: 'clip-vs',
  vs: shaderFunction
};
var injectionVs = {
  'vs:#decl': "\nvarying float clip_isVisible;\n",
  'vs:DECKGL_FILTER_GL_POSITION': "\n  clip_isVisible = float(clip_isInBounds(geometry.worldPosition.xy));\n",
  'fs:#decl': "\nvarying float clip_isVisible;\n",
  'fs:DECKGL_FILTER_COLOR': "\n  if (clip_isVisible < 0.5) discard;\n"
};
var shaderModuleFs = {
  name: 'clip-fs',
  fs: shaderFunction
};
var injectionFs = {
  'vs:#decl': "\nvarying vec2 clip_commonPosition;\n",
  'vs:DECKGL_FILTER_GL_POSITION': "\n  clip_commonPosition = geometry.position.xy;\n",
  'fs:#decl': "\nvarying vec2 clip_commonPosition;\n",
  'fs:DECKGL_FILTER_COLOR': "\n  if (!clip_isInBounds(clip_commonPosition)) discard;\n"
};

var ClipExtension = function (_LayerExtension) {
  (0, _inherits2["default"])(ClipExtension, _LayerExtension);

  function ClipExtension() {
    (0, _classCallCheck2["default"])(this, ClipExtension);
    return (0, _possibleConstructorReturn2["default"])(this, (0, _getPrototypeOf2["default"])(ClipExtension).apply(this, arguments));
  }

  (0, _createClass2["default"])(ClipExtension, [{
    key: "getShaders",
    value: function getShaders() {
      var clipByInstance = 'instancePositions' in this.getAttributeManager().attributes;

      if ('clipByInstance' in this.props) {
        clipByInstance = this.props.clipByInstance;
      }

      this.state.clipByInstance = clipByInstance;
      return clipByInstance ? {
        modules: [shaderModuleVs],
        inject: injectionVs
      } : {
        modules: [shaderModuleFs],
        inject: injectionFs
      };
    }
  }, {
    key: "draw",
    value: function draw(_ref) {
      var uniforms = _ref.uniforms;
      var _this$props$clipBound = this.props.clipBounds,
          clipBounds = _this$props$clipBound === void 0 ? defaultProps.clipBounds : _this$props$clipBound;

      if (this.state.clipByInstance) {
        uniforms.clip_bounds = clipBounds;
      } else {
        var corner0 = this.projectPosition([clipBounds[0], clipBounds[1], 0]);
        var corner1 = this.projectPosition([clipBounds[2], clipBounds[3], 0]);
        uniforms.clip_bounds = [Math.min(corner0[0], corner1[0]), Math.min(corner0[1], corner1[1]), Math.max(corner0[0], corner1[0]), Math.max(corner0[1], corner1[1])];
      }
    }
  }]);
  return ClipExtension;
}(_core.LayerExtension);

exports["default"] = ClipExtension;
ClipExtension.extensionName = 'ClipExtension';
ClipExtension.defaultProps = defaultProps;
//# sourceMappingURL=clip-extension.js.map