"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _math = require("math.gl");

var _mvt = require("@loaders.gl/mvt");

var _core = require("@loaders.gl/core");

var _core2 = require("@deck.gl/core");

var _tileLayer = _interopRequireDefault(require("../tile-layer/tile-layer"));

var _utils = require("../tile-layer/utils");

var _clipExtension = _interopRequireDefault(require("./clip-extension"));

var WORLD_SIZE = 512;
var defaultProps = {
  uniqueIdProperty: {
    type: 'string',
    value: ''
  },
  highlightedFeatureId: null
};

var MVTLayer = function (_TileLayer) {
  (0, _inherits2["default"])(MVTLayer, _TileLayer);

  function MVTLayer() {
    (0, _classCallCheck2["default"])(this, MVTLayer);
    return (0, _possibleConstructorReturn2["default"])(this, (0, _getPrototypeOf2["default"])(MVTLayer).apply(this, arguments));
  }

  (0, _createClass2["default"])(MVTLayer, [{
    key: "getTileData",
    value: function getTileData(tile) {
      var url = (0, _utils.getURLFromTemplate)(this.props.data, tile);

      if (!url) {
        return Promise.reject('Invalid URL');
      }

      return (0, _core.load)(url, _mvt.MVTLoader, this.getLoadOptions());
    }
  }, {
    key: "renderSubLayers",
    value: function renderSubLayers(props) {
      var tile = props.tile;
      var worldScale = Math.pow(2, tile.z);
      var xScale = WORLD_SIZE / worldScale;
      var yScale = -xScale;
      var xOffset = WORLD_SIZE * tile.x / worldScale;
      var yOffset = WORLD_SIZE * (1 - tile.y / worldScale);
      var modelMatrix = new _math.Matrix4().scale([xScale, yScale, 1]);
      props.autoHighlight = false;
      props.modelMatrix = modelMatrix;
      props.coordinateOrigin = [xOffset, yOffset, 0];
      props.coordinateSystem = _core2.COORDINATE_SYSTEM.CARTESIAN;
      props.extensions = [].concat((0, _toConsumableArray2["default"])(props.extensions || []), [new _clipExtension["default"]()]);
      return (0, _get2["default"])((0, _getPrototypeOf2["default"])(MVTLayer.prototype), "renderSubLayers", this).call(this, props);
    }
  }, {
    key: "onHover",
    value: function onHover(info, pickingEvent) {
      var _this$props = this.props,
          uniqueIdProperty = _this$props.uniqueIdProperty,
          autoHighlight = _this$props.autoHighlight;

      if (autoHighlight) {
        var hoveredFeatureId = this.state.hoveredFeatureId;
        var hoveredFeature = info.object;
        var newHoveredFeatureId;

        if (hoveredFeature) {
          newHoveredFeatureId = getFeatureUniqueId(hoveredFeature, uniqueIdProperty);
        }

        if (hoveredFeatureId !== newHoveredFeatureId) {
          this.setState({
            hoveredFeatureId: newHoveredFeatureId
          });
        }
      }

      return (0, _get2["default"])((0, _getPrototypeOf2["default"])(MVTLayer.prototype), "onHover", this).call(this, info, pickingEvent);
    }
  }, {
    key: "getHighlightedObjectIndex",
    value: function getHighlightedObjectIndex(tile) {
      var hoveredFeatureId = this.state.hoveredFeatureId;
      var _this$props2 = this.props,
          uniqueIdProperty = _this$props2.uniqueIdProperty,
          highlightedFeatureId = _this$props2.highlightedFeatureId;
      var data = tile.data;
      var isFeatureIdPresent = isFeatureIdDefined(hoveredFeatureId) || isFeatureIdDefined(highlightedFeatureId);

      if (!isFeatureIdPresent || !Array.isArray(data)) {
        return -1;
      }

      var featureIdToHighlight = isFeatureIdDefined(highlightedFeatureId) ? highlightedFeatureId : hoveredFeatureId;
      return data.findIndex(function (feature) {
        return getFeatureUniqueId(feature, uniqueIdProperty) === featureIdToHighlight;
      });
    }
  }]);
  return MVTLayer;
}(_tileLayer["default"]);

exports["default"] = MVTLayer;

function getFeatureUniqueId(feature, uniqueIdProperty) {
  if (uniqueIdProperty) {
    return feature.properties[uniqueIdProperty];
  }

  if ('id' in feature) {
    return feature.id;
  }

  return -1;
}

function isFeatureIdDefined(value) {
  return value !== undefined && value !== null && value !== '';
}

MVTLayer.layerName = 'MVTLayer';
MVTLayer.defaultProps = defaultProps;
//# sourceMappingURL=mvt-layer.js.map