"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _math = require("math.gl");

var _core = require("@luma.gl/core");

var _core2 = require("@deck.gl/core");

var _layers = require("@deck.gl/layers");

var _meshLayers = require("@deck.gl/mesh-layers");

var _core3 = require("@loaders.gl/core");

var _tiles = require("@loaders.gl/tiles");

var _dTiles = require("@loaders.gl/3d-tiles");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var scratchOffset = new _math.Vector3();
var defaultProps = {
  getPointColor: [0, 0, 0],
  pointSize: 1.0,
  data: null,
  loadOptions: {},
  loader: _dTiles.Tiles3DLoader,
  onTilesetLoad: function onTilesetLoad(tileset3d) {},
  onTileLoad: function onTileLoad(tileHeader) {},
  onTileUnload: function onTileUnload(tileHeader) {},
  onTileError: function onTileError(tile, message, url) {}
};

var Tile3DLayer = function (_CompositeLayer) {
  (0, _inherits2["default"])(Tile3DLayer, _CompositeLayer);

  function Tile3DLayer() {
    (0, _classCallCheck2["default"])(this, Tile3DLayer);
    return (0, _possibleConstructorReturn2["default"])(this, (0, _getPrototypeOf2["default"])(Tile3DLayer).apply(this, arguments));
  }

  (0, _createClass2["default"])(Tile3DLayer, [{
    key: "initializeState",
    value: function initializeState() {
      if ('onTileLoadFail' in this.props) {
        _core2.log.removed('onTileLoadFail', 'onTileError')();
      }

      this.state = {
        layerMap: {},
        tileset3d: null
      };
    }
  }, {
    key: "shouldUpdateState",
    value: function shouldUpdateState(_ref) {
      var changeFlags = _ref.changeFlags;
      return changeFlags.somethingChanged;
    }
  }, {
    key: "updateState",
    value: function updateState(_ref2) {
      var props = _ref2.props,
          oldProps = _ref2.oldProps,
          changeFlags = _ref2.changeFlags;

      if (props.data && props.data !== oldProps.data) {
        this._loadTileset(props.data);
      }

      if (changeFlags.viewportChanged) {
        var tileset3d = this.state.tileset3d;

        this._updateTileset(tileset3d);
      }
    }
  }, {
    key: "getPickingInfo",
    value: function getPickingInfo(_ref3) {
      var info = _ref3.info,
          sourceLayer = _ref3.sourceLayer;
      var layerMap = this.state.layerMap;
      var layerId = sourceLayer && sourceLayer.id;

      if (layerId) {
        var substr = layerId.substring(this.id.length + 1);
        var tileId = substr.substring(substr.indexOf('-') + 1);
        info.object = layerMap[tileId] && layerMap[tileId].tile;
      }

      return info;
    }
  }, {
    key: "_loadTileset",
    value: function () {
      var _loadTileset2 = (0, _asyncToGenerator2["default"])(_regenerator["default"].mark(function _callee(tilesetUrl) {
        var _this$props, loader, loadOptions, options, preloadOptions, tilesetJson, tileset3d;

        return _regenerator["default"].wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _this$props = this.props, loader = _this$props.loader, loadOptions = _this$props.loadOptions;
                options = _objectSpread({}, loadOptions);

                if (!loader.preload) {
                  _context.next = 7;
                  break;
                }

                _context.next = 5;
                return loader.preload(tilesetUrl, loadOptions);

              case 5:
                preloadOptions = _context.sent;
                Object.assign(options, preloadOptions);

              case 7:
                _context.next = 9;
                return (0, _core3.load)(tilesetUrl, loader, options);

              case 9:
                tilesetJson = _context.sent;
                tileset3d = new _tiles.Tileset3D(tilesetJson, _objectSpread({
                  onTileLoad: this._onTileLoad.bind(this),
                  onTileUnload: this._onTileUnload.bind(this),
                  onTileLoadFail: this.props.onTileError
                }, options));
                this.setState({
                  tileset3d: tileset3d,
                  layerMap: {}
                });

                this._updateTileset(tileset3d);

                this.props.onTilesetLoad(tileset3d);

              case 14:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this);
      }));

      function _loadTileset(_x) {
        return _loadTileset2.apply(this, arguments);
      }

      return _loadTileset;
    }()
  }, {
    key: "_onTileLoad",
    value: function _onTileLoad(tileHeader) {
      this.props.onTileLoad(tileHeader);

      this._updateTileset(this.state.tileset3d);

      this.setNeedsUpdate();
    }
  }, {
    key: "_onTileUnload",
    value: function _onTileUnload(tileHeader) {
      delete this.state.layerMap[tileHeader.id];
      this.props.onTileUnload(tileHeader);
    }
  }, {
    key: "_updateTileset",
    value: function _updateTileset(tileset3d) {
      var _this$context = this.context,
          timeline = _this$context.timeline,
          viewport = _this$context.viewport;

      if (!timeline || !viewport || !tileset3d) {
        return;
      }

      var frameNumber = tileset3d.update(viewport);
      var tilesetChanged = this.state.frameNumber !== frameNumber;

      if (tilesetChanged) {
        this.setState({
          frameNumber: frameNumber
        });
      }
    }
  }, {
    key: "_create3DTileLayer",
    value: function _create3DTileLayer(tileHeader) {
      if (!tileHeader.content) {
        return null;
      }

      switch (tileHeader.type) {
        case _tiles.TILE_TYPE.POINTCLOUD:
          return this._createPointCloudTileLayer(tileHeader);

        case _tiles.TILE_TYPE.SCENEGRAPH:
          return this._create3DModelTileLayer(tileHeader);

        case _tiles.TILE_TYPE.MESH:
          return this._createSimpleMeshLayer(tileHeader);

        default:
          throw new Error("Tile3DLayer: Failed to render layer of type ".concat(tileHeader.content.type));
      }
    }
  }, {
    key: "_createPointCloudTileLayer",
    value: function _createPointCloudTileLayer(tileHeader) {
      var _tileHeader$content = tileHeader.content,
          attributes = _tileHeader$content.attributes,
          pointCount = _tileHeader$content.pointCount,
          constantRGBA = _tileHeader$content.constantRGBA,
          cartographicOrigin = _tileHeader$content.cartographicOrigin,
          modelMatrix = _tileHeader$content.modelMatrix;
      var positions = attributes.positions,
          normals = attributes.normals,
          colors = attributes.colors;

      if (!positions) {
        return null;
      }

      var _this$props2 = this.props,
          pointSize = _this$props2.pointSize,
          getPointColor = _this$props2.getPointColor;
      var SubLayerClass = this.getSubLayerClass('pointcloud', _layers.PointCloudLayer);
      return new SubLayerClass({
        pointSize: pointSize
      }, this.getSubLayerProps({
        id: 'pointcloud'
      }), {
        id: "".concat(this.id, "-pointcloud-").concat(tileHeader.id),
        data: {
          header: {
            vertexCount: pointCount
          },
          attributes: {
            POSITION: positions,
            NORMAL: normals,
            COLOR_0: colors
          }
        },
        coordinateSystem: _core2.COORDINATE_SYSTEM.METER_OFFSETS,
        coordinateOrigin: cartographicOrigin,
        modelMatrix: modelMatrix,
        getColor: constantRGBA || getPointColor
      });
    }
  }, {
    key: "_create3DModelTileLayer",
    value: function _create3DModelTileLayer(tileHeader) {
      var _tileHeader$content2 = tileHeader.content,
          gltf = _tileHeader$content2.gltf,
          instances = _tileHeader$content2.instances,
          cartographicOrigin = _tileHeader$content2.cartographicOrigin,
          modelMatrix = _tileHeader$content2.modelMatrix;
      var SubLayerClass = this.getSubLayerClass('scenegraph', _meshLayers.ScenegraphLayer);
      return new SubLayerClass({
        _lighting: 'pbr'
      }, this.getSubLayerProps({
        id: 'scenegraph'
      }), {
        id: "".concat(this.id, "-scenegraph-").concat(tileHeader.id),
        data: instances || [{}],
        scenegraph: gltf,
        coordinateSystem: _core2.COORDINATE_SYSTEM.METER_OFFSETS,
        coordinateOrigin: cartographicOrigin,
        modelMatrix: modelMatrix,
        getTransformMatrix: function getTransformMatrix(instance) {
          return instance.modelMatrix;
        },
        getPosition: function getPosition(instance) {
          return [0, 0, 0];
        }
      });
    }
  }, {
    key: "_createSimpleMeshLayer",
    value: function _createSimpleMeshLayer(tileHeader) {
      var content = tileHeader.content;
      var attributes = content.attributes,
          modelMatrix = content.modelMatrix,
          cartographicOrigin = content.cartographicOrigin,
          texture = content.texture;
      var normals = attributes.normals,
          texCoords = attributes.texCoords;
      var positions = new Float32Array(attributes.positions.value.length);

      for (var i = 0; i < positions.length; i += 3) {
        scratchOffset.copy(attributes.positions.value.subarray(i, i + 3));
        positions.set(scratchOffset, i);
      }

      var geometry = new _core.Geometry({
        drawMode: 4,
        attributes: {
          positions: positions,
          normals: normals,
          texCoords: texCoords
        }
      });
      var SubLayerClass = this.getSubLayerClass('mesh', _meshLayers.SimpleMeshLayer);
      return new SubLayerClass(this.getSubLayerProps({
        id: 'mesh'
      }), {
        id: "".concat(this.id, "-mesh-").concat(tileHeader.id),
        mesh: geometry,
        data: [{}],
        getPosition: [0, 0, 0],
        getColor: [255, 255, 255],
        texture: texture,
        modelMatrix: modelMatrix,
        coordinateOrigin: cartographicOrigin,
        coordinateSystem: _core2.COORDINATE_SYSTEM.METER_OFFSETS
      });
    }
  }, {
    key: "renderLayers",
    value: function renderLayers() {
      var _this = this;

      var _this$state = this.state,
          tileset3d = _this$state.tileset3d,
          layerMap = _this$state.layerMap;

      if (!tileset3d) {
        return null;
      }

      return tileset3d.tiles.map(function (tile) {
        var layer = layerMap[tile.id] && layerMap[tile.id].layer;

        if (tile.selected) {
          if (!layer) {
            layer = _this._create3DTileLayer(tile);
            layerMap[tile.id] = {
              layer: layer,
              tile: tile
            };
          }

          if (layer && layer.props && !layer.props.visible) {
            layer = layer.clone({
              visible: true
            });
            layerMap[tile.id].layer = layer;
          }

          return layer;
        }

        if (layer && layer.props && layer.props.visible) {
          layer = layer.clone({
            visible: false
          });
          layerMap[tile.id].layer = layer;
        }

        return layer;
      }).filter(Boolean);
    }
  }]);
  return Tile3DLayer;
}(_core2.CompositeLayer);

exports["default"] = Tile3DLayer;
Tile3DLayer.layerName = 'Tile3DLayer';
Tile3DLayer.defaultProps = defaultProps;
//# sourceMappingURL=tile-3d-layer.js.map