"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _core = require("@deck.gl/core");

var _layers = require("@deck.gl/layers");

var _tileset2d = _interopRequireWildcard(require("./tileset-2d"));

var _utils = require("./utils");

var defaultProps = {
  data: [],
  dataComparator: _utils.urlType.equals,
  renderSubLayers: {
    type: 'function',
    value: function value(props) {
      return new _layers.GeoJsonLayer(props);
    },
    compare: false
  },
  getTileData: {
    type: 'function',
    optional: true,
    value: null,
    compare: false
  },
  onViewportLoad: {
    type: 'function',
    optional: true,
    value: null,
    compare: false
  },
  onTileLoad: {
    type: 'function',
    value: function value(tile) {},
    compare: false
  },
  onTileError: {
    type: 'function',
    value: function value(err) {
      return console.error(err);
    },
    compare: false
  },
  extent: {
    type: 'array',
    optional: true,
    value: null,
    compare: true
  },
  tileSize: 512,
  maxZoom: null,
  minZoom: 0,
  maxCacheSize: null,
  maxCacheByteSize: null,
  refinementStrategy: _tileset2d.STRATEGY_DEFAULT,
  zRange: null,
  maxRequests: 8
};

var TileLayer = function (_CompositeLayer) {
  (0, _inherits2["default"])(TileLayer, _CompositeLayer);

  function TileLayer() {
    (0, _classCallCheck2["default"])(this, TileLayer);
    return (0, _possibleConstructorReturn2["default"])(this, (0, _getPrototypeOf2["default"])(TileLayer).apply(this, arguments));
  }

  (0, _createClass2["default"])(TileLayer, [{
    key: "initializeState",
    value: function initializeState() {
      this.state = {
        tiles: [],
        isLoaded: false
      };
    }
  }, {
    key: "shouldUpdateState",
    value: function shouldUpdateState(_ref) {
      var changeFlags = _ref.changeFlags;
      return changeFlags.somethingChanged;
    }
  }, {
    key: "updateState",
    value: function updateState(_ref2) {
      var props = _ref2.props,
          oldProps = _ref2.oldProps,
          context = _ref2.context,
          changeFlags = _ref2.changeFlags;
      var tileset = this.state.tileset;
      var createTileCache = !tileset || changeFlags.dataChanged || changeFlags.updateTriggersChanged && (changeFlags.updateTriggersChanged.all || changeFlags.updateTriggersChanged.getTileData);

      if (createTileCache) {
        var maxZoom = props.maxZoom,
            minZoom = props.minZoom,
            tileSize = props.tileSize,
            maxCacheSize = props.maxCacheSize,
            maxCacheByteSize = props.maxCacheByteSize,
            refinementStrategy = props.refinementStrategy,
            extent = props.extent,
            maxRequests = props.maxRequests;
        tileset = new _tileset2d["default"]({
          getTileData: this.getTileData.bind(this),
          maxCacheSize: maxCacheSize,
          maxCacheByteSize: maxCacheByteSize,
          maxZoom: maxZoom,
          minZoom: minZoom,
          tileSize: tileSize,
          refinementStrategy: refinementStrategy,
          extent: extent,
          onTileLoad: this._onTileLoad.bind(this),
          onTileError: this._onTileError.bind(this),
          maxRequests: maxRequests
        });
        this.setState({
          tileset: tileset
        });
      } else if (changeFlags.propsChanged || changeFlags.updateTriggersChanged) {
        tileset.setOptions(props);
        this.state.tileset.tiles.forEach(function (tile) {
          tile.layers = null;
        });
      }

      this._updateTileset();
    }
  }, {
    key: "_updateTileset",
    value: function _updateTileset() {
      var tileset = this.state.tileset;
      var _this$props = this.props,
          onViewportLoad = _this$props.onViewportLoad,
          zRange = _this$props.zRange;
      var frameNumber = tileset.update(this.context.viewport, {
        zRange: zRange
      });
      var isLoaded = tileset.isLoaded;
      var loadingStateChanged = this.state.isLoaded !== isLoaded;
      var tilesetChanged = this.state.frameNumber !== frameNumber;

      if (isLoaded && onViewportLoad && (loadingStateChanged || tilesetChanged)) {
        onViewportLoad(tileset.selectedTiles.map(function (tile) {
          return tile.data;
        }));
      }

      if (tilesetChanged) {
        this.setState({
          frameNumber: frameNumber
        });
      }

      this.state.isLoaded = isLoaded;
    }
  }, {
    key: "_onTileLoad",
    value: function _onTileLoad(tile) {
      var layer = this.getCurrentLayer();
      layer.props.onTileLoad(tile);

      if (tile.isVisible) {
        this.setNeedsUpdate();
      }
    }
  }, {
    key: "_onTileError",
    value: function _onTileError(error, tile) {
      var layer = this.getCurrentLayer();
      layer.props.onTileError(error);

      layer._updateTileset();

      if (tile.isVisible) {
        this.setNeedsUpdate();
      }
    }
  }, {
    key: "getTileData",
    value: function getTileData(tile) {
      var _this$props2 = this.props,
          getTileData = _this$props2.getTileData,
          fetch = _this$props2.fetch,
          data = _this$props2.data;
      tile.url = (0, _utils.getURLFromTemplate)(data, tile);

      if (getTileData) {
        return getTileData(tile);
      }

      if (tile.url) {
        return fetch(tile.url, {
          layer: this
        });
      }

      return null;
    }
  }, {
    key: "renderSubLayers",
    value: function renderSubLayers(props) {
      return this.props.renderSubLayers(props);
    }
  }, {
    key: "getHighlightedObjectIndex",
    value: function getHighlightedObjectIndex() {
      return -1;
    }
  }, {
    key: "getPickingInfo",
    value: function getPickingInfo(_ref3) {
      var info = _ref3.info,
          sourceLayer = _ref3.sourceLayer;
      info.sourceLayer = sourceLayer;
      info.tile = sourceLayer.props.tile;
      return info;
    }
  }, {
    key: "renderLayers",
    value: function renderLayers() {
      var _this = this;

      var visible = this.props.visible;
      return this.state.tileset.tiles.map(function (tile) {
        var isVisible = visible && tile.isVisible;

        var highlightedObjectIndex = _this.getHighlightedObjectIndex(tile);

        if (!tile.isLoaded) {} else if (!tile.layers) {
          var layers = _this.renderSubLayers(Object.assign({}, _this.props, {
            id: "".concat(_this.id, "-").concat(tile.x, "-").concat(tile.y, "-").concat(tile.z),
            data: tile.data,
            visible: isVisible,
            _offset: 0,
            tile: tile,
            highlightedObjectIndex: highlightedObjectIndex
          }));

          tile.layers = (0, _core._flatten)(layers, Boolean);
        } else if (tile.layers[0] && (tile.layers[0].props.visible !== isVisible || tile.layers[0].props.highlightedObjectIndex !== highlightedObjectIndex)) {
          tile.layers = tile.layers.map(function (layer) {
            return layer.clone({
              visible: isVisible,
              highlightedObjectIndex: highlightedObjectIndex
            });
          });
        }

        return tile.layers;
      });
    }
  }, {
    key: "isLoaded",
    get: function get() {
      var tileset = this.state.tileset;
      return tileset.selectedTiles.every(function (tile) {
        return tile.layers && tile.layers.every(function (layer) {
          return layer.isLoaded;
        });
      });
    }
  }]);
  return TileLayer;
}(_core.CompositeLayer);

exports["default"] = TileLayer;
TileLayer.layerName = 'TileLayer';
TileLayer.defaultProps = defaultProps;
//# sourceMappingURL=tile-layer.js.map