import { LayerExtension } from '@deck.gl/core';
const defaultProps = {
  clipBounds: [0, 0, 1, 1]
};
const shaderFunction = "\nuniform vec4 clip_bounds;\n\nbool clip_isInBounds(vec2 position) {\n  return position.x >= clip_bounds[0] && position.y >= clip_bounds[1] && position.x < clip_bounds[2] && position.y < clip_bounds[3];\n}\n";
const shaderModuleVs = {
  name: 'clip-vs',
  vs: shaderFunction
};
const injectionVs = {
  'vs:#decl': "\nvarying float clip_isVisible;\n",
  'vs:DECKGL_FILTER_GL_POSITION': "\n  clip_isVisible = float(clip_isInBounds(geometry.worldPosition.xy));\n",
  'fs:#decl': "\nvarying float clip_isVisible;\n",
  'fs:DECKGL_FILTER_COLOR': "\n  if (clip_isVisible < 0.5) discard;\n"
};
const shaderModuleFs = {
  name: 'clip-fs',
  fs: shaderFunction
};
const injectionFs = {
  'vs:#decl': "\nvarying vec2 clip_commonPosition;\n",
  'vs:DECKGL_FILTER_GL_POSITION': "\n  clip_commonPosition = geometry.position.xy;\n",
  'fs:#decl': "\nvarying vec2 clip_commonPosition;\n",
  'fs:DECKGL_FILTER_COLOR': "\n  if (!clip_isInBounds(clip_commonPosition)) discard;\n"
};
export default class ClipExtension extends LayerExtension {
  getShaders() {
    let clipByInstance = 'instancePositions' in this.getAttributeManager().attributes;

    if ('clipByInstance' in this.props) {
      clipByInstance = this.props.clipByInstance;
    }

    this.state.clipByInstance = clipByInstance;
    return clipByInstance ? {
      modules: [shaderModuleVs],
      inject: injectionVs
    } : {
      modules: [shaderModuleFs],
      inject: injectionFs
    };
  }

  draw({
    uniforms
  }) {
    const {
      clipBounds = defaultProps.clipBounds
    } = this.props;

    if (this.state.clipByInstance) {
      uniforms.clip_bounds = clipBounds;
    } else {
      const corner0 = this.projectPosition([clipBounds[0], clipBounds[1], 0]);
      const corner1 = this.projectPosition([clipBounds[2], clipBounds[3], 0]);
      uniforms.clip_bounds = [Math.min(corner0[0], corner1[0]), Math.min(corner0[1], corner1[1]), Math.max(corner0[0], corner1[0]), Math.max(corner0[1], corner1[1])];
    }
  }

}
ClipExtension.extensionName = 'ClipExtension';
ClipExtension.defaultProps = defaultProps;
//# sourceMappingURL=clip-extension.js.map