import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import { CompositeLayer } from '@deck.gl/core';
import { SimpleMeshLayer } from '@deck.gl/mesh-layers';
import { WebMercatorViewport, COORDINATE_SYSTEM } from '@deck.gl/core';
import { load } from '@loaders.gl/core';
import { TerrainLoader } from '@loaders.gl/terrain';
import TileLayer from '../tile-layer/tile-layer';
import { urlType, getURLFromTemplate } from '../tile-layer/utils';
const DUMMY_DATA = [1];

const defaultProps = _objectSpread({}, TileLayer.defaultProps, {
  elevationData: urlType,
  texture: urlType,
  meshMaxError: {
    type: 'number',
    value: 4.0
  },
  bounds: {
    type: 'array',
    value: null,
    optional: true,
    compare: true
  },
  color: {
    type: 'color',
    value: [255, 255, 255]
  },
  elevationDecoder: {
    type: 'object',
    value: {
      rScaler: 1,
      gScaler: 0,
      bScaler: 0,
      offset: 0
    }
  },
  workerUrl: {
    type: 'string',
    value: null
  },
  wireframe: false,
  material: true
});

function urlTemplateToUpdateTrigger(template) {
  if (Array.isArray(template)) {
    return template.join(';');
  }

  return template;
}

export default class TerrainLayer extends CompositeLayer {
  updateState({
    props,
    oldProps
  }) {
    const elevationDataChanged = props.elevationData !== oldProps.elevationData;

    if (elevationDataChanged) {
      const {
        elevationData
      } = props;
      const isTiled = elevationData && (Array.isArray(elevationData) || elevationData.includes('{x}') && elevationData.includes('{y}'));
      this.setState({
        isTiled
      });
    }

    const shouldReload = elevationDataChanged || props.meshMaxError !== oldProps.meshMaxError || props.elevationDecoder !== oldProps.elevationDecoder || props.bounds !== oldProps.bounds;

    if (!this.state.isTiled && shouldReload) {
      const terrain = this.loadTerrain(props);
      this.setState({
        terrain
      });
    }
  }

  loadTerrain({
    elevationData,
    bounds,
    elevationDecoder,
    meshMaxError,
    workerUrl
  }) {
    if (!elevationData) {
      return null;
    }

    const options = {
      terrain: {
        bounds,
        meshMaxError,
        elevationDecoder
      }
    };

    if (workerUrl !== null) {
      options.terrain.workerUrl = workerUrl;
    }

    return load(elevationData, TerrainLoader, options);
  }

  getTiledTerrainData(tile) {
    const {
      elevationData,
      texture,
      elevationDecoder,
      meshMaxError,
      workerUrl
    } = this.props;
    const dataUrl = getURLFromTemplate(elevationData, tile);
    const textureUrl = getURLFromTemplate(texture, tile);
    const {
      bbox,
      z
    } = tile;
    const viewport = new WebMercatorViewport({
      longitude: (bbox.west + bbox.east) / 2,
      latitude: (bbox.north + bbox.south) / 2,
      zoom: z
    });
    const bottomLeft = viewport.projectFlat([bbox.west, bbox.south]);
    const topRight = viewport.projectFlat([bbox.east, bbox.north]);
    const bounds = [bottomLeft[0], bottomLeft[1], topRight[0], topRight[1]];
    const terrain = this.loadTerrain({
      elevationData: dataUrl,
      bounds,
      elevationDecoder,
      meshMaxError,
      workerUrl
    });
    const surface = textureUrl ? load(textureUrl).catch(_ => null) : Promise.resolve(null);
    return Promise.all([terrain, surface]);
  }

  renderSubLayers(props) {
    const SubLayerClass = this.getSubLayerClass('mesh', SimpleMeshLayer);
    const {
      data,
      color
    } = props;

    if (!data) {
      return null;
    }

    const [mesh, texture] = data;
    return new SubLayerClass(props, {
      data: DUMMY_DATA,
      mesh,
      texture,
      coordinateSystem: COORDINATE_SYSTEM.CARTESIAN,
      getPosition: d => [0, 0, 0],
      getColor: color
    });
  }

  onViewportLoad(data) {
    if (!data || data.length === 0 || data.every(x => !x)) {
      return;
    }

    const {
      zRange
    } = this.state;
    const ranges = data.filter(Boolean).map(arr => {
      const bounds = arr[0].header.boundingBox;
      return bounds.map(bound => bound[2]);
    });
    const minZ = Math.min(...ranges.map(x => x[0]));
    const maxZ = Math.max(...ranges.map(x => x[1]));

    if (!zRange || minZ < zRange[0] || maxZ > zRange[1]) {
      this.setState({
        zRange: [minZ, maxZ]
      });
    }
  }

  renderLayers() {
    const {
      color,
      material,
      elevationData,
      texture,
      wireframe,
      meshMaxError,
      elevationDecoder
    } = this.props;

    if (this.state.isTiled) {
      return new TileLayer(this.getSubLayerProps({
        id: 'tiles'
      }), {
        wireframe,
        color,
        material,
        getTileData: this.getTiledTerrainData.bind(this),
        renderSubLayers: this.renderSubLayers.bind(this),
        updateTriggers: {
          getTileData: {
            elevationData: urlTemplateToUpdateTrigger(elevationData),
            texture: urlTemplateToUpdateTrigger(texture),
            meshMaxError,
            elevationDecoder
          }
        },
        onViewportLoad: this.onViewportLoad.bind(this),
        zRange: this.state.zRange || null
      });
    }

    const SubLayerClass = this.getSubLayerClass('mesh', SimpleMeshLayer);
    return new SubLayerClass(this.getSubLayerProps({
      id: 'mesh'
    }), {
      data: DUMMY_DATA,
      mesh: this.state.terrain,
      texture,
      _instanced: false,
      getPosition: d => [0, 0, 0],
      getColor: color,
      material,
      wireframe
    });
  }

}
TerrainLayer.layerName = 'TerrainLayer';
TerrainLayer.defaultProps = defaultProps;
//# sourceMappingURL=terrain-layer.js.map