import _regeneratorRuntime from "@babel/runtime/regenerator";
import _asyncToGenerator from "@babel/runtime/helpers/esm/asyncToGenerator";
import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
import { log } from '@deck.gl/core';

var Tile2DHeader = function () {
  function Tile2DHeader(_ref) {
    var x = _ref.x,
        y = _ref.y,
        z = _ref.z,
        onTileLoad = _ref.onTileLoad,
        onTileError = _ref.onTileError;

    _classCallCheck(this, Tile2DHeader);

    this.x = x;
    this.y = y;
    this.z = z;
    this.isVisible = false;
    this.isSelected = false;
    this.parent = null;
    this.children = [];
    this.content = null;
    this._isLoaded = false;
    this._isCancelled = false;
    this.onTileLoad = onTileLoad;
    this.onTileError = onTileError;
  }

  _createClass(Tile2DHeader, [{
    key: "_loadData",
    value: function () {
      var _loadData2 = _asyncToGenerator(_regeneratorRuntime.mark(function _callee(getTileData, requestScheduler) {
        var x, y, z, bbox, requestToken, tileData, error;
        return _regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                x = this.x, y = this.y, z = this.z, bbox = this.bbox;
                _context.next = 3;
                return requestScheduler.scheduleRequest(this, function (tile) {
                  return tile.isSelected ? 1 : -1;
                });

              case 3:
                requestToken = _context.sent;

                if (requestToken) {
                  _context.next = 7;
                  break;
                }

                this._isCancelled = true;
                return _context.abrupt("return");

              case 7:
                this._isCancelled = false;
                _context.prev = 8;
                _context.next = 11;
                return getTileData({
                  x: x,
                  y: y,
                  z: z,
                  bbox: bbox
                });

              case 11:
                tileData = _context.sent;
                _context.next = 17;
                break;

              case 14:
                _context.prev = 14;
                _context.t0 = _context["catch"](8);
                error = _context.t0 || true;

              case 17:
                _context.prev = 17;
                requestToken.done();
                this._isLoaded = true;
                return _context.finish(17);

              case 21:
                if (error) {
                  this.onTileError(error, this);
                } else {
                  this.content = tileData;
                  this.onTileLoad(this);
                }

              case 22:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this, [[8, 14, 17, 21]]);
      }));

      function _loadData(_x, _x2) {
        return _loadData2.apply(this, arguments);
      }

      return _loadData;
    }()
  }, {
    key: "loadData",
    value: function loadData(getTileData, requestScheduler) {
      if (!getTileData) {
        return;
      }

      this._loader = this._loadData(getTileData, requestScheduler);
    }
  }, {
    key: "data",
    get: function get() {
      return this._isLoaded ? this.content : this._loader;
    }
  }, {
    key: "isLoaded",
    get: function get() {
      return this._isLoaded;
    }
  }, {
    key: "isCancelled",
    get: function get() {
      return this._isCancelled;
    }
  }, {
    key: "byteLength",
    get: function get() {
      var result = this.content ? this.content.byteLength : 0;

      if (!Number.isFinite(result)) {
        log.error('byteLength not defined in tile data')();
      }

      return result;
    }
  }]);

  return Tile2DHeader;
}();

export { Tile2DHeader as default };
//# sourceMappingURL=tile-2d-header.js.map