import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
import { CullingVolume, Plane, AxisAlignedBoundingBox } from '@math.gl/culling';
var TILE_SIZE = 512;
var MAX_MAPS = 3;

var OSMNode = function () {
  function OSMNode(x, y, z) {
    _classCallCheck(this, OSMNode);

    this.x = x;
    this.y = y;
    this.z = z;
  }

  _createClass(OSMNode, [{
    key: "update",
    value: function update(params) {
      var viewport = params.viewport,
          cullingVolume = params.cullingVolume,
          elevationBounds = params.elevationBounds,
          minZ = params.minZ,
          maxZ = params.maxZ,
          offset = params.offset;
      var boundingVolume = this.getBoundingVolume(elevationBounds, offset);
      var isInside = cullingVolume.computeVisibility(boundingVolume);

      if (isInside < 0) {
        return false;
      }

      if (!this.childVisible) {
        var z = this.z;

        if (z < maxZ && z >= minZ) {
          var distance = boundingVolume.distanceTo(viewport.cameraPosition) * viewport.scale / viewport.height;
          z += Math.floor(Math.log2(distance));
        }

        if (z >= maxZ) {
          this.selected = true;
          return true;
        }
      }

      this.selected = false;
      this.childVisible = true;
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = this.children[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var child = _step.value;
          child.update(params);
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator["return"] != null) {
            _iterator["return"]();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      return true;
    }
  }, {
    key: "getSelected",
    value: function getSelected() {
      var result = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];

      if (this.selected) {
        result.push(this);
      }

      if (this._children) {
        var _iteratorNormalCompletion2 = true;
        var _didIteratorError2 = false;
        var _iteratorError2 = undefined;

        try {
          for (var _iterator2 = this._children[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
            var node = _step2.value;
            node.getSelected(result);
          }
        } catch (err) {
          _didIteratorError2 = true;
          _iteratorError2 = err;
        } finally {
          try {
            if (!_iteratorNormalCompletion2 && _iterator2["return"] != null) {
              _iterator2["return"]();
            }
          } finally {
            if (_didIteratorError2) {
              throw _iteratorError2;
            }
          }
        }
      }

      return result;
    }
  }, {
    key: "getBoundingVolume",
    value: function getBoundingVolume(zRange, worldOffset) {
      var scale = Math.pow(2, this.z);
      var extent = TILE_SIZE / scale;
      var originX = this.x * extent + worldOffset * TILE_SIZE;
      var originY = TILE_SIZE - (this.y + 1) * extent;
      return new AxisAlignedBoundingBox([originX, originY, zRange[0]], [originX + extent, originY + extent, zRange[1]]);
    }
  }, {
    key: "children",
    get: function get() {
      if (!this._children) {
        var x = this.x * 2;
        var y = this.y * 2;
        var z = this.z + 1;
        this._children = [new OSMNode(x, y, z), new OSMNode(x, y + 1, z), new OSMNode(x + 1, y, z), new OSMNode(x + 1, y + 1, z)];
      }

      return this._children;
    }
  }]);

  return OSMNode;
}();

export function getOSMTileIndices(viewport, maxZ, zRange) {
  var planes = Object.values(viewport.getFrustumPlanes()).map(function (_ref) {
    var normal = _ref.normal,
        distance = _ref.distance;
    return new Plane(normal.clone().negate(), distance);
  });
  var cullingVolume = new CullingVolume(planes);
  var unitsPerMeter = viewport.distanceScales.unitsPerMeter[2];
  var elevationMin = zRange && zRange[0] * unitsPerMeter || 0;
  var elevationMax = zRange && zRange[1] * unitsPerMeter || 0;
  var minZ = viewport.pitch <= 60 ? maxZ : 0;
  var root = new OSMNode(0, 0, 0);
  var traversalParams = {
    viewport: viewport,
    cullingVolume: cullingVolume,
    elevationBounds: [elevationMin, elevationMax],
    minZ: minZ,
    maxZ: maxZ,
    offset: 0
  };
  root.update(traversalParams);

  if (viewport.subViewports && viewport.subViewports.length > 1) {
    traversalParams.offset = -1;

    while (root.update(traversalParams)) {
      if (--traversalParams.offset < -MAX_MAPS) {
        break;
      }
    }

    traversalParams.offset = 1;

    while (root.update(traversalParams)) {
      if (++traversalParams.offset > MAX_MAPS) {
        break;
      }
    }
  }

  return root.getSelected();
}
//# sourceMappingURL=tile-2d-traversal.js.map