"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getS2QuadKey = getS2QuadKey;
exports.getS2Polygon = getS2Polygon;

var _s2Geometry = require("./s2-geometry");

var _long = _interopRequireDefault(require("long"));

function getIdFromToken(token) {
  var paddedToken = token.padEnd(16, '0');
  return _long["default"].fromString(paddedToken, 16);
}

var MAX_RESOLUTION = 100;

function getGeoBounds(_ref) {
  var face = _ref.face,
      ij = _ref.ij,
      level = _ref.level;
  var offsets = [[0, 0], [0, 1], [1, 1], [1, 0], [0, 0]];
  var resolution = Math.max(1, Math.ceil(MAX_RESOLUTION * Math.pow(2, -level)));
  var result = new Float64Array(4 * resolution * 2 + 2);
  var ptIndex = 0;

  for (var i = 0; i < 4; i++) {
    var offset = offsets[i].slice(0);
    var nextOffset = offsets[i + 1];
    var stepI = (nextOffset[0] - offset[0]) / resolution;
    var stepJ = (nextOffset[1] - offset[1]) / resolution;

    for (var j = 0; j < resolution; j++) {
      offset[0] += stepI;
      offset[1] += stepJ;
      var st = (0, _s2Geometry.IJToST)(ij, level, offset);
      var uv = (0, _s2Geometry.STToUV)(st);
      var xyz = (0, _s2Geometry.FaceUVToXYZ)(face, uv);
      var lngLat = (0, _s2Geometry.XYZToLngLat)(xyz);
      result[ptIndex++] = lngLat[0];
      result[ptIndex++] = lngLat[1];
    }
  }

  result[ptIndex++] = result[0];
  result[ptIndex++] = result[1];
  return result;
}

function getS2QuadKey(token) {
  if (typeof token === 'string') {
    if (token.indexOf('/') > 0) {
      return token;
    }

    token = getIdFromToken(token);
  }

  return (0, _s2Geometry.toHilbertQuadkey)(token.toString());
}

function getS2Polygon(token) {
  var key = getS2QuadKey(token);
  var s2cell = (0, _s2Geometry.FromHilbertQuadKey)(key);
  return getGeoBounds(s2cell);
}
//# sourceMappingURL=s2-utils.js.map