"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _core = require("@deck.gl/core");

var _meshLayers = require("@deck.gl/mesh-layers");

var _core2 = require("@loaders.gl/core");

var _terrain = require("@loaders.gl/terrain");

var _tileLayer = _interopRequireDefault(require("../tile-layer/tile-layer"));

var _utils = require("../tile-layer/utils");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var DUMMY_DATA = [1];

var defaultProps = _objectSpread({}, _tileLayer["default"].defaultProps, {
  elevationData: _utils.urlType,
  texture: _utils.urlType,
  meshMaxError: {
    type: 'number',
    value: 4.0
  },
  bounds: {
    type: 'array',
    value: null,
    optional: true,
    compare: true
  },
  color: {
    type: 'color',
    value: [255, 255, 255]
  },
  elevationDecoder: {
    type: 'object',
    value: {
      rScaler: 1,
      gScaler: 0,
      bScaler: 0,
      offset: 0
    }
  },
  workerUrl: {
    type: 'string',
    value: null
  },
  wireframe: false,
  material: true
});

function urlTemplateToUpdateTrigger(template) {
  if (Array.isArray(template)) {
    return template.join(';');
  }

  return template;
}

var TerrainLayer = function (_CompositeLayer) {
  (0, _inherits2["default"])(TerrainLayer, _CompositeLayer);

  function TerrainLayer() {
    (0, _classCallCheck2["default"])(this, TerrainLayer);
    return (0, _possibleConstructorReturn2["default"])(this, (0, _getPrototypeOf2["default"])(TerrainLayer).apply(this, arguments));
  }

  (0, _createClass2["default"])(TerrainLayer, [{
    key: "updateState",
    value: function updateState(_ref) {
      var props = _ref.props,
          oldProps = _ref.oldProps;
      var elevationDataChanged = props.elevationData !== oldProps.elevationData;

      if (elevationDataChanged) {
        var elevationData = props.elevationData;
        var isTiled = elevationData && (Array.isArray(elevationData) || elevationData.includes('{x}') && elevationData.includes('{y}'));
        this.setState({
          isTiled: isTiled
        });
      }

      var shouldReload = elevationDataChanged || props.meshMaxError !== oldProps.meshMaxError || props.elevationDecoder !== oldProps.elevationDecoder || props.bounds !== oldProps.bounds;

      if (!this.state.isTiled && shouldReload) {
        var terrain = this.loadTerrain(props);
        this.setState({
          terrain: terrain
        });
      }
    }
  }, {
    key: "loadTerrain",
    value: function loadTerrain(_ref2) {
      var elevationData = _ref2.elevationData,
          bounds = _ref2.bounds,
          elevationDecoder = _ref2.elevationDecoder,
          meshMaxError = _ref2.meshMaxError,
          workerUrl = _ref2.workerUrl;

      if (!elevationData) {
        return null;
      }

      var options = {
        terrain: {
          bounds: bounds,
          meshMaxError: meshMaxError,
          elevationDecoder: elevationDecoder
        }
      };

      if (workerUrl !== null) {
        options.terrain.workerUrl = workerUrl;
      }

      return (0, _core2.load)(elevationData, _terrain.TerrainLoader, options);
    }
  }, {
    key: "getTiledTerrainData",
    value: function getTiledTerrainData(tile) {
      var _this$props = this.props,
          elevationData = _this$props.elevationData,
          texture = _this$props.texture,
          elevationDecoder = _this$props.elevationDecoder,
          meshMaxError = _this$props.meshMaxError,
          workerUrl = _this$props.workerUrl;
      var dataUrl = (0, _utils.getURLFromTemplate)(elevationData, tile);
      var textureUrl = (0, _utils.getURLFromTemplate)(texture, tile);
      var bbox = tile.bbox,
          z = tile.z;
      var viewport = new _core.WebMercatorViewport({
        longitude: (bbox.west + bbox.east) / 2,
        latitude: (bbox.north + bbox.south) / 2,
        zoom: z
      });
      var bottomLeft = viewport.projectFlat([bbox.west, bbox.south]);
      var topRight = viewport.projectFlat([bbox.east, bbox.north]);
      var bounds = [bottomLeft[0], bottomLeft[1], topRight[0], topRight[1]];
      var terrain = this.loadTerrain({
        elevationData: dataUrl,
        bounds: bounds,
        elevationDecoder: elevationDecoder,
        meshMaxError: meshMaxError,
        workerUrl: workerUrl
      });
      var surface = textureUrl ? (0, _core2.load)(textureUrl)["catch"](function (_) {
        return null;
      }) : Promise.resolve(null);
      return Promise.all([terrain, surface]);
    }
  }, {
    key: "renderSubLayers",
    value: function renderSubLayers(props) {
      var SubLayerClass = this.getSubLayerClass('mesh', _meshLayers.SimpleMeshLayer);
      var data = props.data,
          color = props.color;

      if (!data) {
        return null;
      }

      var _data = (0, _slicedToArray2["default"])(data, 2),
          mesh = _data[0],
          texture = _data[1];

      return new SubLayerClass(props, {
        data: DUMMY_DATA,
        mesh: mesh,
        texture: texture,
        coordinateSystem: _core.COORDINATE_SYSTEM.CARTESIAN,
        getPosition: function getPosition(d) {
          return [0, 0, 0];
        },
        getColor: color
      });
    }
  }, {
    key: "onViewportLoad",
    value: function onViewportLoad(data) {
      if (!data || data.length === 0 || data.every(function (x) {
        return !x;
      })) {
        return;
      }

      var zRange = this.state.zRange;
      var ranges = data.filter(Boolean).map(function (arr) {
        var bounds = arr[0].header.boundingBox;
        return bounds.map(function (bound) {
          return bound[2];
        });
      });
      var minZ = Math.min.apply(Math, (0, _toConsumableArray2["default"])(ranges.map(function (x) {
        return x[0];
      })));
      var maxZ = Math.max.apply(Math, (0, _toConsumableArray2["default"])(ranges.map(function (x) {
        return x[1];
      })));

      if (!zRange || minZ < zRange[0] || maxZ > zRange[1]) {
        this.setState({
          zRange: [minZ, maxZ]
        });
      }
    }
  }, {
    key: "renderLayers",
    value: function renderLayers() {
      var _this$props2 = this.props,
          color = _this$props2.color,
          material = _this$props2.material,
          elevationData = _this$props2.elevationData,
          texture = _this$props2.texture,
          wireframe = _this$props2.wireframe,
          meshMaxError = _this$props2.meshMaxError,
          elevationDecoder = _this$props2.elevationDecoder;

      if (this.state.isTiled) {
        return new _tileLayer["default"](this.getSubLayerProps({
          id: 'tiles'
        }), {
          wireframe: wireframe,
          color: color,
          material: material,
          getTileData: this.getTiledTerrainData.bind(this),
          renderSubLayers: this.renderSubLayers.bind(this),
          updateTriggers: {
            getTileData: {
              elevationData: urlTemplateToUpdateTrigger(elevationData),
              texture: urlTemplateToUpdateTrigger(texture),
              meshMaxError: meshMaxError,
              elevationDecoder: elevationDecoder
            }
          },
          onViewportLoad: this.onViewportLoad.bind(this),
          zRange: this.state.zRange || null
        });
      }

      var SubLayerClass = this.getSubLayerClass('mesh', _meshLayers.SimpleMeshLayer);
      return new SubLayerClass(this.getSubLayerProps({
        id: 'mesh'
      }), {
        data: DUMMY_DATA,
        mesh: this.state.terrain,
        texture: texture,
        _instanced: false,
        getPosition: function getPosition(d) {
          return [0, 0, 0];
        },
        getColor: color,
        material: material,
        wireframe: wireframe
      });
    }
  }]);
  return TerrainLayer;
}(_core.CompositeLayer);

exports["default"] = TerrainLayer;
TerrainLayer.layerName = 'TerrainLayer';
TerrainLayer.defaultProps = defaultProps;
//# sourceMappingURL=terrain-layer.js.map