"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _layers = require("@deck.gl/layers");

var defaultProps = {
  trailLength: {
    type: 'number',
    value: 120,
    min: 0
  },
  currentTime: {
    type: 'number',
    value: 0,
    min: 0
  },
  getTimestamps: {
    type: 'accessor',
    value: null
  }
};

var TripsLayer = function (_PathLayer) {
  (0, _inherits2["default"])(TripsLayer, _PathLayer);

  function TripsLayer() {
    (0, _classCallCheck2["default"])(this, TripsLayer);
    return (0, _possibleConstructorReturn2["default"])(this, (0, _getPrototypeOf2["default"])(TripsLayer).apply(this, arguments));
  }

  (0, _createClass2["default"])(TripsLayer, [{
    key: "getShaders",
    value: function getShaders() {
      var shaders = (0, _get2["default"])((0, _getPrototypeOf2["default"])(TripsLayer.prototype), "getShaders", this).call(this);
      shaders.inject = {
        'vs:#decl': "uniform float trailLength;\nattribute float instanceTimestamps;\nattribute float instanceNextTimestamps;\nvarying float vTime;\n",
        'vs:#main-end': "vTime = instanceTimestamps + (instanceNextTimestamps - instanceTimestamps) * vPathPosition.y / vPathLength;\n",
        'fs:#decl': "uniform float trailLength;\nuniform float currentTime;\nvarying float vTime;\n",
        'fs:#main-start': "if(vTime > currentTime || vTime < currentTime - trailLength) {\n  discard;\n}\n",
        'fs:DECKGL_FILTER_COLOR': 'color.a *= 1.0 - (currentTime - vTime) / trailLength;'
      };
      return shaders;
    }
  }, {
    key: "initializeState",
    value: function initializeState(params) {
      (0, _get2["default"])((0, _getPrototypeOf2["default"])(TripsLayer.prototype), "initializeState", this).call(this, params);
      var attributeManager = this.getAttributeManager();
      attributeManager.addInstanced({
        timestamps: {
          size: 1,
          accessor: 'getTimestamps',
          shaderAttributes: {
            instanceTimestamps: {
              vertexOffset: 0
            },
            instanceNextTimestamps: {
              vertexOffset: 1
            }
          }
        }
      });
    }
  }, {
    key: "draw",
    value: function draw(params) {
      var _this$props = this.props,
          trailLength = _this$props.trailLength,
          currentTime = _this$props.currentTime;
      params.uniforms = Object.assign({}, params.uniforms, {
        trailLength: trailLength,
        currentTime: currentTime
      });
      (0, _get2["default"])((0, _getPrototypeOf2["default"])(TripsLayer.prototype), "draw", this).call(this, params);
    }
  }]);
  return TripsLayer;
}(_layers.PathLayer);

exports["default"] = TripsLayer;
TripsLayer.layerName = 'TripsLayer';
TripsLayer.defaultProps = defaultProps;
//# sourceMappingURL=trips-layer.js.map