import _toConsumableArray from "@babel/runtime/helpers/esm/toConsumableArray";
import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/esm/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/esm/getPrototypeOf";
import _get from "@babel/runtime/helpers/esm/get";
import _inherits from "@babel/runtime/helpers/esm/inherits";
import { Matrix4 } from 'math.gl';
import { MVTLoader } from '@loaders.gl/mvt';
import { load } from '@loaders.gl/core';
import { COORDINATE_SYSTEM } from '@deck.gl/core';
import TileLayer from '../tile-layer/tile-layer';
import { getURLFromTemplate } from '../tile-layer/utils';
import ClipExtension from './clip-extension';
var WORLD_SIZE = 512;
var defaultProps = {
  uniqueIdProperty: {
    type: 'string',
    value: ''
  },
  highlightedFeatureId: null
};

var MVTLayer = function (_TileLayer) {
  _inherits(MVTLayer, _TileLayer);

  function MVTLayer() {
    _classCallCheck(this, MVTLayer);

    return _possibleConstructorReturn(this, _getPrototypeOf(MVTLayer).apply(this, arguments));
  }

  _createClass(MVTLayer, [{
    key: "getTileData",
    value: function getTileData(tile) {
      var url = getURLFromTemplate(this.props.data, tile);

      if (!url) {
        return Promise.reject('Invalid URL');
      }

      return load(url, MVTLoader, this.getLoadOptions());
    }
  }, {
    key: "renderSubLayers",
    value: function renderSubLayers(props) {
      var tile = props.tile;
      var worldScale = Math.pow(2, tile.z);
      var xScale = WORLD_SIZE / worldScale;
      var yScale = -xScale;
      var xOffset = WORLD_SIZE * tile.x / worldScale;
      var yOffset = WORLD_SIZE * (1 - tile.y / worldScale);
      var modelMatrix = new Matrix4().scale([xScale, yScale, 1]);
      props.autoHighlight = false;
      props.modelMatrix = modelMatrix;
      props.coordinateOrigin = [xOffset, yOffset, 0];
      props.coordinateSystem = COORDINATE_SYSTEM.CARTESIAN;
      props.extensions = [].concat(_toConsumableArray(props.extensions || []), [new ClipExtension()]);
      return _get(_getPrototypeOf(MVTLayer.prototype), "renderSubLayers", this).call(this, props);
    }
  }, {
    key: "onHover",
    value: function onHover(info, pickingEvent) {
      var _this$props = this.props,
          uniqueIdProperty = _this$props.uniqueIdProperty,
          autoHighlight = _this$props.autoHighlight;

      if (autoHighlight) {
        var hoveredFeatureId = this.state.hoveredFeatureId;
        var hoveredFeature = info.object;
        var newHoveredFeatureId;

        if (hoveredFeature) {
          newHoveredFeatureId = getFeatureUniqueId(hoveredFeature, uniqueIdProperty);
        }

        if (hoveredFeatureId !== newHoveredFeatureId) {
          this.setState({
            hoveredFeatureId: newHoveredFeatureId
          });
        }
      }

      return _get(_getPrototypeOf(MVTLayer.prototype), "onHover", this).call(this, info, pickingEvent);
    }
  }, {
    key: "getHighlightedObjectIndex",
    value: function getHighlightedObjectIndex(tile) {
      var hoveredFeatureId = this.state.hoveredFeatureId;
      var _this$props2 = this.props,
          uniqueIdProperty = _this$props2.uniqueIdProperty,
          highlightedFeatureId = _this$props2.highlightedFeatureId;
      var data = tile.data;
      var isFeatureIdPresent = isFeatureIdDefined(hoveredFeatureId) || isFeatureIdDefined(highlightedFeatureId);

      if (!isFeatureIdPresent || !Array.isArray(data)) {
        return -1;
      }

      var featureIdToHighlight = isFeatureIdDefined(highlightedFeatureId) ? highlightedFeatureId : hoveredFeatureId;
      return data.findIndex(function (feature) {
        return getFeatureUniqueId(feature, uniqueIdProperty) === featureIdToHighlight;
      });
    }
  }]);

  return MVTLayer;
}(TileLayer);

export { MVTLayer as default };

function getFeatureUniqueId(feature, uniqueIdProperty) {
  if (uniqueIdProperty) {
    return feature.properties[uniqueIdProperty];
  }

  if ('id' in feature) {
    return feature.id;
  }

  return -1;
}

function isFeatureIdDefined(value) {
  return value !== undefined && value !== null && value !== '';
}

MVTLayer.layerName = 'MVTLayer';
MVTLayer.defaultProps = defaultProps;
//# sourceMappingURL=mvt-layer.js.map