import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
import Tile2DHeader from './tile-2d-header';
import { getTileIndices as _getTileIndices, tileToBoundingBox } from './utils';
import { RequestScheduler } from '@loaders.gl/loader-utils';
var TILE_STATE_UNKNOWN = 0;
var TILE_STATE_VISIBLE = 1;
var TILE_STATE_PLACEHOLDER = 3;
var TILE_STATE_HIDDEN = 4;
var TILE_STATE_SELECTED = 5;
export var STRATEGY_NEVER = 'never';
export var STRATEGY_REPLACE = 'no-overlap';
export var STRATEGY_DEFAULT = 'best-available';
var DEFAULT_CACHE_SCALE = 5;

var Tileset2D = function () {
  function Tileset2D(opts) {
    var _this = this;

    _classCallCheck(this, Tileset2D);

    this.opts = opts;
    this._getTileData = opts.getTileData;
    this.onTileError = opts.onTileError;

    this.onTileLoad = function (tile) {
      opts.onTileLoad(tile);

      if (_this.opts.maxCacheByteSize) {
        _this._cacheByteSize += tile.byteLength;

        _this._resizeCache();
      }
    };

    this._requestScheduler = new RequestScheduler({
      maxRequests: opts.maxRequests,
      throttleRequests: opts.maxRequests > 0
    });
    this._cache = new Map();
    this._tiles = [];
    this._dirty = false;
    this._cacheByteSize = 0;
    this._viewport = null;
    this._selectedTiles = null;
    this._frameNumber = 0;
    this.setOptions(opts);
  }

  _createClass(Tileset2D, [{
    key: "setOptions",
    value: function setOptions(opts) {
      Object.assign(this.opts, opts);

      if (Number.isFinite(opts.maxZoom)) {
        this._maxZoom = Math.floor(opts.maxZoom);
      }

      if (Number.isFinite(opts.minZoom)) {
        this._minZoom = Math.ceil(opts.minZoom);
      }
    }
  }, {
    key: "update",
    value: function update(viewport) {
      var _this2 = this;

      var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
          zRange = _ref.zRange;

      if (!viewport.equals(this._viewport)) {
        this._viewport = viewport;
        var tileIndices = this.getTileIndices({
          viewport: viewport,
          maxZoom: this._maxZoom,
          minZoom: this._minZoom,
          zRange: zRange
        });
        this._selectedTiles = tileIndices.map(function (index) {
          return _this2._getTile(index, true);
        });

        if (this._dirty) {
          this._rebuildTree();
        }
      }

      var changed = this.updateTileStates();

      if (this._dirty) {
        this._resizeCache();
      }

      if (changed) {
        this._frameNumber++;
      }

      return this._frameNumber;
    }
  }, {
    key: "getTileIndices",
    value: function getTileIndices(_ref2) {
      var viewport = _ref2.viewport,
          maxZoom = _ref2.maxZoom,
          minZoom = _ref2.minZoom,
          zRange = _ref2.zRange;
      var _this$opts = this.opts,
          tileSize = _this$opts.tileSize,
          extent = _this$opts.extent;
      return _getTileIndices({
        viewport: viewport,
        maxZoom: maxZoom,
        minZoom: minZoom,
        zRange: zRange,
        tileSize: tileSize,
        extent: extent
      });
    }
  }, {
    key: "getTileMetadata",
    value: function getTileMetadata(_ref3) {
      var x = _ref3.x,
          y = _ref3.y,
          z = _ref3.z;
      return {
        bbox: tileToBoundingBox(this._viewport, x, y, z)
      };
    }
  }, {
    key: "getParentIndex",
    value: function getParentIndex(tileIndex) {
      tileIndex.x = Math.floor(tileIndex.x / 2);
      tileIndex.y = Math.floor(tileIndex.y / 2);
      tileIndex.z -= 1;
      return tileIndex;
    }
  }, {
    key: "updateTileStates",
    value: function updateTileStates() {
      this._updateTileStates(this.selectedTiles);

      var changed = false;
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = this._cache.values()[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var tile = _step.value;
          var isVisible = Boolean(tile.state & TILE_STATE_VISIBLE);

          if (tile.isVisible !== isVisible) {
            changed = true;
            tile.isVisible = isVisible;
          }

          tile.isSelected = tile.state === TILE_STATE_SELECTED;
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator["return"] != null) {
            _iterator["return"]();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      return changed;
    }
  }, {
    key: "_rebuildTree",
    value: function _rebuildTree() {
      var _cache = this._cache;
      var _iteratorNormalCompletion2 = true;
      var _didIteratorError2 = false;
      var _iteratorError2 = undefined;

      try {
        for (var _iterator2 = _cache.values()[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
          var tile = _step2.value;
          tile.parent = null;
          tile.children.length = 0;
        }
      } catch (err) {
        _didIteratorError2 = true;
        _iteratorError2 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion2 && _iterator2["return"] != null) {
            _iterator2["return"]();
          }
        } finally {
          if (_didIteratorError2) {
            throw _iteratorError2;
          }
        }
      }

      var _iteratorNormalCompletion3 = true;
      var _didIteratorError3 = false;
      var _iteratorError3 = undefined;

      try {
        for (var _iterator3 = _cache.values()[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
          var _tile = _step3.value;

          var parent = this._getNearestAncestor(_tile.x, _tile.y, _tile.z);

          _tile.parent = parent;

          if (parent) {
            parent.children.push(_tile);
          }
        }
      } catch (err) {
        _didIteratorError3 = true;
        _iteratorError3 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion3 && _iterator3["return"] != null) {
            _iterator3["return"]();
          }
        } finally {
          if (_didIteratorError3) {
            throw _iteratorError3;
          }
        }
      }
    }
  }, {
    key: "_updateTileStates",
    value: function _updateTileStates(selectedTiles) {
      var _cache = this._cache;
      var refinementStrategy = this.opts.refinementStrategy || STRATEGY_DEFAULT;
      var _iteratorNormalCompletion4 = true;
      var _didIteratorError4 = false;
      var _iteratorError4 = undefined;

      try {
        for (var _iterator4 = _cache.values()[Symbol.iterator](), _step4; !(_iteratorNormalCompletion4 = (_step4 = _iterator4.next()).done); _iteratorNormalCompletion4 = true) {
          var tile = _step4.value;
          tile.state = TILE_STATE_UNKNOWN;
        }
      } catch (err) {
        _didIteratorError4 = true;
        _iteratorError4 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion4 && _iterator4["return"] != null) {
            _iterator4["return"]();
          }
        } finally {
          if (_didIteratorError4) {
            throw _iteratorError4;
          }
        }
      }

      var _iteratorNormalCompletion5 = true;
      var _didIteratorError5 = false;
      var _iteratorError5 = undefined;

      try {
        for (var _iterator5 = selectedTiles[Symbol.iterator](), _step5; !(_iteratorNormalCompletion5 = (_step5 = _iterator5.next()).done); _iteratorNormalCompletion5 = true) {
          var _tile2 = _step5.value;
          _tile2.state = TILE_STATE_SELECTED;
        }
      } catch (err) {
        _didIteratorError5 = true;
        _iteratorError5 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion5 && _iterator5["return"] != null) {
            _iterator5["return"]();
          }
        } finally {
          if (_didIteratorError5) {
            throw _iteratorError5;
          }
        }
      }

      if (refinementStrategy === STRATEGY_NEVER) {
        return;
      }

      var _iteratorNormalCompletion6 = true;
      var _didIteratorError6 = false;
      var _iteratorError6 = undefined;

      try {
        for (var _iterator6 = selectedTiles[Symbol.iterator](), _step6; !(_iteratorNormalCompletion6 = (_step6 = _iterator6.next()).done); _iteratorNormalCompletion6 = true) {
          var _tile3 = _step6.value;
          getPlaceholderInAncestors(_tile3, refinementStrategy);
        }
      } catch (err) {
        _didIteratorError6 = true;
        _iteratorError6 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion6 && _iterator6["return"] != null) {
            _iterator6["return"]();
          }
        } finally {
          if (_didIteratorError6) {
            throw _iteratorError6;
          }
        }
      }

      var _iteratorNormalCompletion7 = true;
      var _didIteratorError7 = false;
      var _iteratorError7 = undefined;

      try {
        for (var _iterator7 = selectedTiles[Symbol.iterator](), _step7; !(_iteratorNormalCompletion7 = (_step7 = _iterator7.next()).done); _iteratorNormalCompletion7 = true) {
          var _tile4 = _step7.value;

          if (needsPlaceholder(_tile4)) {
            getPlaceholderInChildren(_tile4);
          }
        }
      } catch (err) {
        _didIteratorError7 = true;
        _iteratorError7 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion7 && _iterator7["return"] != null) {
            _iterator7["return"]();
          }
        } finally {
          if (_didIteratorError7) {
            throw _iteratorError7;
          }
        }
      }
    }
  }, {
    key: "_resizeCache",
    value: function _resizeCache() {
      var _cache = this._cache,
          opts = this.opts;
      var maxCacheSize = opts.maxCacheSize || (opts.maxCacheByteSize ? Infinity : DEFAULT_CACHE_SCALE * this.selectedTiles.length);
      var maxCacheByteSize = opts.maxCacheByteSize || Infinity;
      var overflown = _cache.size > maxCacheSize || this._cacheByteSize > maxCacheByteSize;

      if (overflown) {
        var _iteratorNormalCompletion8 = true;
        var _didIteratorError8 = false;
        var _iteratorError8 = undefined;

        try {
          for (var _iterator8 = _cache[Symbol.iterator](), _step8; !(_iteratorNormalCompletion8 = (_step8 = _iterator8.next()).done); _iteratorNormalCompletion8 = true) {
            var _step8$value = _slicedToArray(_step8.value, 2),
                tileId = _step8$value[0],
                tile = _step8$value[1];

            if (!tile.isVisible) {
              this._cacheByteSize -= opts.maxCacheByteSize ? tile.byteLength : 0;

              _cache["delete"](tileId);
            }

            if (_cache.size <= maxCacheSize && this._cacheByteSize <= maxCacheByteSize) {
              break;
            }
          }
        } catch (err) {
          _didIteratorError8 = true;
          _iteratorError8 = err;
        } finally {
          try {
            if (!_iteratorNormalCompletion8 && _iterator8["return"] != null) {
              _iterator8["return"]();
            }
          } finally {
            if (_didIteratorError8) {
              throw _iteratorError8;
            }
          }
        }

        this._rebuildTree();

        this._dirty = true;
      }

      if (this._dirty) {
        this._tiles = Array.from(this._cache.values()).sort(function (t1, t2) {
          return t1.z - t2.z;
        });
        this._dirty = false;
      }
    }
  }, {
    key: "_getTile",
    value: function _getTile(_ref4, create) {
      var x = _ref4.x,
          y = _ref4.y,
          z = _ref4.z;
      var tileId = "".concat(x, ",").concat(y, ",").concat(z);

      var tile = this._cache.get(tileId);

      if (!tile && create) {
        tile = new Tile2DHeader({
          x: x,
          y: y,
          z: z,
          onTileLoad: this.onTileLoad,
          onTileError: this.onTileError
        });
        Object.assign(tile, this.getTileMetadata(tile));
        tile.loadData(this._getTileData, this._requestScheduler);

        this._cache.set(tileId, tile);

        this._dirty = true;
      } else if (tile && tile.isCancelled) {
        tile.loadData(this._getTileData, this._requestScheduler);
      }

      return tile;
    }
  }, {
    key: "_getNearestAncestor",
    value: function _getNearestAncestor(x, y, z) {
      var _this$_minZoom = this._minZoom,
          _minZoom = _this$_minZoom === void 0 ? 0 : _this$_minZoom;

      var index = {
        x: x,
        y: y,
        z: z
      };

      while (index.z > _minZoom) {
        index = this.getParentIndex(index);

        var parent = this._getTile(index);

        if (parent) {
          return parent;
        }
      }

      return null;
    }
  }, {
    key: "tiles",
    get: function get() {
      return this._tiles;
    }
  }, {
    key: "selectedTiles",
    get: function get() {
      return this._selectedTiles;
    }
  }, {
    key: "isLoaded",
    get: function get() {
      return this._selectedTiles.every(function (tile) {
        return tile.isLoaded;
      });
    }
  }]);

  return Tileset2D;
}();

export { Tileset2D as default };

function needsPlaceholder(tile) {
  var t = tile;

  while (t) {
    if (t.state & TILE_STATE_VISIBLE === 0) {
      return true;
    }

    if (t.isLoaded) {
      return false;
    }

    t = t.parent;
  }

  return true;
}

function getPlaceholderInAncestors(tile, refinementStrategy) {
  var parent;
  var state = TILE_STATE_PLACEHOLDER;

  while (parent = tile.parent) {
    if (tile.isLoaded) {
      state = TILE_STATE_HIDDEN;

      if (refinementStrategy === STRATEGY_DEFAULT) {
        return;
      }
    }

    parent.state = Math.max(parent.state, state);
    tile = parent;
  }
}

function getPlaceholderInChildren(tile) {
  var _iteratorNormalCompletion9 = true;
  var _didIteratorError9 = false;
  var _iteratorError9 = undefined;

  try {
    for (var _iterator9 = tile.children[Symbol.iterator](), _step9; !(_iteratorNormalCompletion9 = (_step9 = _iterator9.next()).done); _iteratorNormalCompletion9 = true) {
      var child = _step9.value;
      child.state = Math.max(child.state, TILE_STATE_PLACEHOLDER);

      if (!child.isLoaded) {
        getPlaceholderInChildren(child);
      }
    }
  } catch (err) {
    _didIteratorError9 = true;
    _iteratorError9 = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion9 && _iterator9["return"] != null) {
        _iterator9["return"]();
      }
    } finally {
      if (_didIteratorError9) {
        throw _iteratorError9;
      }
    }
  }
}
//# sourceMappingURL=tileset-2d.js.map